/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.tracker.combined.PyramidKltForCombined;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;

public class FactoryTrackerAlg {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> KltTracker<I, D> klt(KltConfig config, Class<I> imageType, Class<D> derivType) {
        InterpolateRectangle<I> interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle<D> interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        return new KltTracker<I, D>(interpInput, interpDeriv, config);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> PyramidKltTracker<I, D> kltPyramid(KltConfig config, Class<I> imageType, Class<D> derivType) {
        InterpolateRectangle<I> interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle<D> interpDeriv = FactoryInterpolation.bilinearRectangle(derivType);
        KltTracker<I, D> klt = new KltTracker<I, D>(interpInput, interpDeriv, config);
        return new PyramidKltTracker<I, D>(klt);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand, Desc extends TupleDesc> CombinedTrackerScalePoint<I, D, Desc> combined(DetectDescribePoint<I, Desc> detector, AssociateDescription<Desc> associate, int featureRadiusKlt, int[] pyramidScalingKlt, Class<I> imageType, Class<D> derivType) {
        KltConfig configKlt = KltConfig.createDefault();
        PyramidKltForCombined<I, D> klt = new PyramidKltForCombined<I, D>(configKlt, featureRadiusKlt, pyramidScalingKlt, imageType, derivType);
        return new CombinedTrackerScalePoint<I, D, Desc>(klt, detector, associate);
    }
}

