/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.binary;

import boofcv.alg.feature.detect.edge.EdgeContour;
import boofcv.alg.feature.detect.edge.EdgeSegment;
import boofcv.alg.filter.binary.Contour;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import georegression.struct.point.Point2D_I32;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Random;
import sun.awt.image.ByteInterleavedRaster;
import sun.awt.image.IntegerInterleavedRaster;

public class VisualizeBinaryData {
    public static BufferedImage renderContours(List<EdgeContour> edges, int[] colors, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        colors = VisualizeBinaryData.checkColors(colors, edges.size());
        for (int i = 0; i < edges.size(); ++i) {
            EdgeContour e = edges.get(i);
            int color = colors[i];
            for (EdgeSegment s : e.segments) {
                for (Point2D_I32 p : s.points) {
                    out.setRGB(p.x, p.y, color);
                }
            }
        }
        return out;
    }

    public static BufferedImage renderContours(List<Contour> contours, int colorExternal, int colorInternal, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        for (Contour c : contours) {
            for (Point2D_I32 point2D_I32 : c.external) {
                out.setRGB(point2D_I32.x, point2D_I32.y, colorExternal);
            }
            for (List list : c.internal) {
                for (Point2D_I32 p : list) {
                    out.setRGB(p.x, p.y, colorInternal);
                }
            }
        }
        return out;
    }

    public static BufferedImage renderContours(List<Contour> contours, int[] colorExternal, int colorInternal, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        } else {
            Graphics2D g2 = out.createGraphics();
            g2.setColor(Color.BLACK);
            g2.fillRect(0, 0, width, height);
        }
        colorExternal = VisualizeBinaryData.checkColors(colorExternal, contours.size());
        int index = 0;
        for (Contour c : contours) {
            int color = colorExternal[index++];
            for (Point2D_I32 point2D_I32 : c.external) {
                out.setRGB(point2D_I32.x, point2D_I32.y, color);
            }
            for (List list : c.internal) {
                for (Point2D_I32 p : list) {
                    out.setRGB(p.x, p.y, colorInternal);
                }
            }
        }
        return out;
    }

    public static BufferedImage renderExternal(List<Contour> contours, int[] colors, int width, int height, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(width, height, 1);
        }
        colors = VisualizeBinaryData.checkColors(colors, contours.size());
        for (Contour c : contours) {
            int color = colors[c.id - 1];
            for (Point2D_I32 p : c.external) {
                out.setRGB(p.x, p.y, color);
            }
        }
        return out;
    }

    public static int[] checkColors(int[] colors, int size) {
        if (colors == null) {
            colors = new int[size];
            Random rand = new Random(123L);
            for (int i = 0; i < size; ++i) {
                colors[i] = rand.nextInt();
            }
        }
        return colors;
    }

    public static BufferedImage renderLabeled(ImageSInt32 labelImage, int[] colors, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(labelImage.getWidth(), labelImage.getHeight(), 1);
        }
        try {
            if (out.getRaster() instanceof IntegerInterleavedRaster) {
                VisualizeBinaryData.renderLabeled(labelImage, colors, (IntegerInterleavedRaster)out.getRaster());
            } else {
                VisualizeBinaryData._renderLabeled(labelImage, out, colors);
            }
        }
        catch (SecurityException e) {
            VisualizeBinaryData._renderLabeled(labelImage, out, colors);
        }
        return out;
    }

    public static BufferedImage renderLabeled(ImageSInt32 labelImage, int numColors, BufferedImage out) {
        int[] colors = new int[numColors + 1];
        Random rand = new Random(123L);
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = rand.nextInt();
        }
        colors[0] = 0;
        return VisualizeBinaryData.renderLabeled(labelImage, colors, out);
    }

    private static void _renderLabeled(ImageSInt32 labelImage, BufferedImage out, int[] colors) {
        int w = labelImage.getWidth();
        int h = labelImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = labelImage.startIndex + y * labelImage.stride;
            for (int x = 0; x < w; ++x) {
                int rgb = colors[labelImage.data[indexSrc++]];
                out.setRGB(x, y, rgb);
            }
        }
    }

    private static void renderLabeled(ImageSInt32 labelImage, int[] colors, IntegerInterleavedRaster raster) {
        int rasterIndex = 0;
        int[] data = raster.getDataStorage();
        int w = labelImage.getWidth();
        int h = labelImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = labelImage.startIndex + y * labelImage.stride;
            for (int x = 0; x < w; ++x) {
                data[rasterIndex++] = colors[labelImage.data[indexSrc++]];
            }
        }
    }

    public static BufferedImage renderBinary(ImageUInt8 binaryImage, BufferedImage out) {
        if (out == null) {
            out = new BufferedImage(binaryImage.getWidth(), binaryImage.getHeight(), 10);
        }
        try {
            if (out.getRaster() instanceof ByteInterleavedRaster) {
                VisualizeBinaryData.renderBinary(binaryImage, (ByteInterleavedRaster)out.getRaster());
            } else {
                VisualizeBinaryData._renderBinary(binaryImage, out);
            }
        }
        catch (SecurityException e) {
            VisualizeBinaryData._renderBinary(binaryImage, out);
        }
        return out;
    }

    private static void _renderBinary(ImageUInt8 binaryImage, BufferedImage out) {
        int w = binaryImage.getWidth();
        int h = binaryImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
            for (int x = 0; x < w; ++x) {
                int rgb = binaryImage.data[indexSrc++] > 0 ? 0xFFFFFF : 0;
                out.setRGB(x, y, rgb);
            }
        }
    }

    private static void renderBinary(ImageUInt8 binaryImage, ByteInterleavedRaster raster) {
        int rasterIndex = 0;
        byte[] data = raster.getDataStorage();
        int w = binaryImage.getWidth();
        int h = binaryImage.getHeight();
        for (int y = 0; y < h; ++y) {
            int indexSrc = binaryImage.startIndex + y * binaryImage.stride;
            for (int x = 0; x < w; ++x) {
                data[rasterIndex++] = binaryImage.data[indexSrc++] > 0 ? -1 : 0;
            }
        }
    }
}

