/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io;

import java.io.File;
import javax.swing.JFileChooser;

public class UtilIO {
    public static String getPathToBase() {
        String path = "./";
        for (int i = 0; i < 3; ++i) {
            File f = new File(path);
            if (!f.exists()) {
                throw new RuntimeException("Failed");
            }
            String[] files = f.list();
            boolean foundMain = false;
            boolean foundLib = false;
            for (String s : files) {
                if (s.compareToIgnoreCase("main") == 0) {
                    foundMain = true;
                    continue;
                }
                if (s.compareToIgnoreCase("lib") != 0) continue;
                foundLib = true;
            }
            if (foundMain && foundLib) {
                return path;
            }
            path = "../" + path;
        }
        throw new RuntimeException("Base not found");
    }

    public static String selectFile(boolean exitOnCancel) {
        String fileName = null;
        JFileChooser fc = new JFileChooser();
        int returnVal = fc.showOpenDialog(null);
        if (returnVal == 0) {
            fileName = fc.getSelectedFile().getAbsolutePath();
        } else if (exitOnCancel) {
            System.exit(0);
        }
        return fileName;
    }

    public static void loadLibrarySmart(String libraryName) {
        String[] stuff;
        if (UtilIO.loadLibrary(libraryName)) {
            return;
        }
        String classPath = System.getProperty("java.class.path");
        for (String s : stuff = classPath.split(":")) {
            File f = new File(s);
            if (!f.isDirectory() || !(f = new File(s + "/" + libraryName)).exists()) continue;
            String libraryPath = System.getProperty("java.library.path");
            libraryPath = libraryPath + ":" + s;
            System.setProperty("java.library.path", libraryPath);
            if (!UtilIO.loadLibrary(libraryName)) {
                throw new RuntimeException("Shouldn't have failed to load this time");
            }
            return;
        }
        System.out.println("classPath");
    }

    public static boolean loadLibrary(String libraryName) {
        try {
            System.out.println("tring to load: " + libraryName);
            System.loadLibrary(libraryName);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }
}

