/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.video;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;

public class CreateMJpeg {
    private static byte[] buffer = new byte[10240];

    private static byte[] filterData(DataInputStream in) throws IOException {
        block13: while (in.available() > 0) {
            int header = in.read();
            if (header != 255) {
                throw new IllegalArgumentException("Expected 0xFF not " + Integer.toHexString(header));
            }
            int mark = in.readUnsignedByte();
            System.out.println(" mark = " + Integer.toHexString(mark));
            switch (mark) {
                case 216: {
                    return CreateMJpeg.createMarker((byte)mark);
                }
                case 192: {
                    return CreateMJpeg.readUntilMarker(in, (byte)mark, (byte)-39);
                }
                case 194: {
                    return CreateMJpeg.readUntilMarker(in, (byte)mark, (byte)-39);
                }
                case 196: {
                    return CreateMJpeg.readVariableLength(in, (byte)mark);
                }
                case 219: {
                    return CreateMJpeg.readVariableLength(in, (byte)mark);
                }
                case 221: {
                    throw new RuntimeException("Need to handle");
                }
                case 218: {
                    return CreateMJpeg.readVariableLength(in, (byte)mark);
                }
                case 208: 
                case 209: 
                case 210: 
                case 211: 
                case 212: 
                case 213: 
                case 214: 
                case 215: {
                    return CreateMJpeg.createMarker((byte)mark);
                }
                case 224: 
                case 225: 
                case 226: 
                case 227: 
                case 228: 
                case 229: 
                case 230: 
                case 231: 
                case 232: 
                case 233: 
                case 234: 
                case 235: 
                case 236: 
                case 237: 
                case 238: 
                case 239: {
                    CreateMJpeg.readVariableLength(in, (byte)mark);
                    continue block13;
                }
                case 254: {
                    CreateMJpeg.readVariableLength(in, (byte)mark);
                    continue block13;
                }
                case 217: {
                    throw new IllegalArgumentException("Should never read this");
                }
            }
            throw new IllegalArgumentException("Unexpected");
        }
        return null;
    }

    private static byte[] createMarker(byte type) {
        return new byte[]{-1, type};
    }

    private static byte[] readVariableLength(DataInputStream in, byte type) throws IOException {
        int actual;
        int length;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        bout.write(255);
        bout.write(type & 0xFF);
        bout.write(length);
        for (length = in.readUnsignedShort() - 2; length > 0 && in.available() > 0; length -= actual) {
            int amount = Math.min(buffer.length, length);
            actual = in.read(buffer, 0, amount);
            bout.write(buffer, 0, actual);
        }
        return bout.toByteArray();
    }

    private static byte[] readUntilMarker(DataInputStream in, byte type, byte endMarker) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream(1024);
        bout.write(255);
        bout.write(type & 0xFF);
        int length = in.readUnsignedShort();
        bout.write(length);
        boolean foundFF = false;
        while (length > 0 && in.available() > 0) {
            byte b = in.readByte();
            if (foundFF) {
                if (b == endMarker) {
                    return bout.toByteArray();
                }
                bout.write(255);
                bout.write(b);
                if (b == 255) continue;
                foundFF = false;
                continue;
            }
            if (b == -1) {
                foundFF = true;
                continue;
            }
            bout.write(b);
        }
        return bout.toByteArray();
    }

    public static void main(String[] args) throws IOException {
        File directory = new File("/home/pja/temp/a");
        File[] files = directory.listFiles();
        ArrayList<String> list = new ArrayList<String>();
        for (File f : files) {
            if (!f.isFile() || !f.getName().endsWith(".jpg")) continue;
            list.add(f.getPath());
        }
        Collections.sort(list);
        int i = -1;
        DataOutputStream out = new DataOutputStream(new FileOutputStream(directory.getPath() + "/movie.mjpeg"));
        for (String n : list) {
            System.out.println("Reading in: " + n);
            DataInputStream in = new DataInputStream(new FileInputStream(n));
            while (in.available() > 0) {
                byte[] data = new byte[in.available()];
                in.read(data);
                out.write(data);
            }
            in.close();
        }
        out.close();
    }
}

