/*
 * Decompiled with CFR 0.152.
 */
package boofcv.io.wrapper.images;

import boofcv.core.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.video.CombineFilesTogether;
import boofcv.io.video.VideoMjpegCodec;
import boofcv.struct.GrowQueue_I8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageDataType;
import boofcv.struct.image.ImageUInt16;
import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class ImageStreamSequence<T extends ImageBase>
implements SimpleImageSequence<T> {
    String fileName;
    DataInputStream in;
    BufferedImage original;
    BufferedImage next;
    T image;
    int frameNumber;
    ImageDataType<T> imageType;
    GrowQueue_I8 buffer = new GrowQueue_I8();
    byte[] rawData;

    public ImageStreamSequence(InputStream in, boolean storeData, ImageDataType<T> imageType) {
        if (storeData) {
            try {
                this.rawData = VideoMjpegCodec.convertToByteArray(in);
                this.in = new DataInputStream(new ByteArrayInputStream(this.rawData));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            this.in = new DataInputStream(in);
        }
        this.imageType = imageType;
        this.image = imageType.createImage(1, 1);
        this.readNext();
    }

    public ImageStreamSequence(String fileName, boolean storeData, ImageDataType<T> imageType) throws FileNotFoundException {
        this(new DataInputStream(new BufferedInputStream(new FileInputStream(fileName), 204800)), storeData, imageType);
        this.fileName = fileName;
    }

    private void readNext() {
        try {
            CombineFilesTogether.readNext(this.in, this.buffer);
            this.next = ImageIO.read(new ByteArrayInputStream(this.buffer.data, 0, this.buffer.size));
            ++this.frameNumber;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public T next() {
        this.original = this.next;
        ((ImageBase)this.image).reshape(this.original.getWidth(), this.original.getHeight());
        ConvertBufferedImage.convertFrom(this.original, this.image);
        this.readNext();
        return this.image;
    }

    @Override
    public BufferedImage getGuiImage() {
        return this.original;
    }

    @Override
    public void close() {
        try {
            this.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.in = null;
    }

    @Override
    public int getFrameNumber() {
        return this.frameNumber - 1;
    }

    @Override
    public void setLoop(boolean loop) {
        if (loop) {
            throw new RuntimeException("Can't loop");
        }
    }

    @Override
    public ImageDataType<T> getImageType() {
        return this.imageType;
    }

    @Override
    public void reset() {
        if (this.rawData != null) {
            this.in = new DataInputStream(new ByteArrayInputStream(this.rawData));
            this.frameNumber = 0;
            this.readNext();
        } else if (this.fileName != null) {
            try {
                this.in = new DataInputStream(new BufferedInputStream(new FileInputStream(this.fileName), 204800));
                this.frameNumber = 0;
                this.readNext();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Reset not supported");
        }
    }

    public static void main(String[] args) throws FileNotFoundException {
        ImageStreamSequence<ImageUInt16> stream = new ImageStreamSequence<ImageUInt16>("combined.mpng", true, ImageDataType.single(ImageUInt16.class));
        while (stream.hasNext()) {
            System.out.println("Image");
            stream.next();
        }
    }
}

