/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public enum AutoTypeImage {
    I("ImageInteger", "int", true, 0),
    I8("ImageInt8", "byte", true, 8),
    U8(ImageUInt8.class),
    S8(ImageSInt8.class),
    I16("ImageInt16", "short", true, 16),
    U16(ImageUInt16.class),
    S16(ImageSInt16.class),
    S32(ImageSInt32.class),
    S64(ImageSInt64.class),
    F32(ImageFloat32.class),
    F64(ImageFloat64.class);

    private String imageName;
    private String dataType;
    private String bitWise;
    private String sumType;
    private String largeSumType;
    private boolean isInteger;
    private boolean isSigned;
    private int numBits;
    private String abbreviatedType;
    private Class<?> primitiveType;

    private AutoTypeImage(Class<?> imageType) {
        this.imageName = imageType.getSimpleName();
        this.bitWise = "";
        try {
            ImageSingleBand img = (ImageSingleBand)imageType.newInstance();
            this.primitiveType = img.getTypeInfo().getDataType();
            this.dataType = this.primitiveType.getSimpleName();
            this.numBits = img.getTypeInfo().getNumBits();
            if (img.getTypeInfo().isInteger()) {
                this.isInteger = true;
                this.sumType = this.numBits <= 32 ? "int" : "long";
                this.largeSumType = this.numBits <= 16 ? "int" : "long";
                if (!img.getTypeInfo().isSigned()) {
                    this.abbreviatedType = "U";
                    this.isSigned = false;
                    if (Byte.TYPE == this.primitiveType) {
                        this.bitWise = "& 0xFF";
                    } else if (Short.TYPE == this.primitiveType) {
                        this.bitWise = "& 0xFFFF";
                    }
                } else {
                    this.abbreviatedType = "S";
                    this.isSigned = true;
                }
            } else {
                this.abbreviatedType = "F";
                this.isSigned = true;
                this.isInteger = false;
                this.sumType = imageType == ImageFloat32.class ? "float" : "double";
                this.largeSumType = "double";
            }
            this.abbreviatedType = this.abbreviatedType + this.numBits;
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private AutoTypeImage(String imageName, String dataType, boolean isInteger, int numBits) {
        this.imageName = imageName;
        this.dataType = dataType;
        this.isInteger = isInteger;
        this.numBits = numBits;
        if (isInteger) {
            this.abbreviatedType = "I";
            this.sumType = "int";
        } else {
            this.sumType = "double";
        }
        this.abbreviatedType = this.abbreviatedType + numBits;
    }

    public static AutoTypeImage[] getIntegerTypes() {
        return new AutoTypeImage[]{U8, S8, U16, S16, S32, S64};
    }

    public static AutoTypeImage[] getFloatingTypes() {
        return new AutoTypeImage[]{F32, F64};
    }

    public static AutoTypeImage[] getGenericTypes() {
        return new AutoTypeImage[]{I8, I16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getReallyGenericTypes() {
        return new AutoTypeImage[]{I, S64, F32, F64};
    }

    public static AutoTypeImage[] getSpecificTypes() {
        return new AutoTypeImage[]{U8, S8, U16, S16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getSigned() {
        return new AutoTypeImage[]{S8, S16, S32, S64, F32, F64};
    }

    public static AutoTypeImage[] getUnsigned() {
        return new AutoTypeImage[]{U8, U16};
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getBitWise() {
        return this.bitWise;
    }

    public String getSumType() {
        return this.sumType;
    }

    public String getLargeSumType() {
        return this.largeSumType;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public int getNumBits() {
        return this.numBits;
    }

    public Class<?> getPrimitiveType() {
        return this.primitiveType;
    }

    public String getTypeCastFromSum() {
        if (this.sumType.compareTo(this.dataType) != 0) {
            return "(" + this.dataType + ")";
        }
        return "";
    }

    public String getAbbreviatedType() {
        return this.abbreviatedType;
    }

    public String getRandType() {
        return this.primitiveType == Float.TYPE ? "Float" : "Double";
    }

    public Number getMax() {
        if (this.isInteger) {
            if (Byte.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (byte)127;
                }
                return 255;
            }
            if (Short.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (short)Short.MAX_VALUE;
                }
                return 65535;
            }
            return Integer.MAX_VALUE;
        }
        if (Float.TYPE == this.primitiveType) {
            return Float.valueOf(Float.MAX_VALUE);
        }
        return Double.MAX_VALUE;
    }

    public Number getMin() {
        if (this.isInteger) {
            if (Byte.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (byte)-128;
                }
                return 0;
            }
            if (Short.TYPE == this.primitiveType) {
                if (this.isSigned) {
                    return (short)Short.MIN_VALUE;
                }
                return 0;
            }
            return Integer.MIN_VALUE;
        }
        if (Float.TYPE == this.primitiveType) {
            return Float.valueOf(Float.MIN_VALUE);
        }
        return Double.MIN_VALUE;
    }
}

