/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.FastQueueList;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class FastQueue<T> {
    public T[] data;
    public int size;
    public Class<T> type;
    private boolean declareInstances;
    private FastQueueList<T> list = new FastQueueList(this);

    public FastQueue(int initialMaxSize, Class<T> type, boolean declareInstances) {
        this.init(initialMaxSize, type, declareInstances);
    }

    public FastQueue(Class<T> type, boolean declareInstances) {
        this(10, type, declareInstances);
    }

    protected FastQueue() {
    }

    protected void init(int initialMaxSize, Class<T> type, boolean declareInstances) {
        this.size = 0;
        this.type = type;
        this.declareInstances = declareInstances;
        this.data = (Object[])Array.newInstance(type, initialMaxSize);
        if (declareInstances) {
            for (int i = 0; i < initialMaxSize; ++i) {
                this.data[i] = this.createInstance();
            }
        }
    }

    public List<T> toList() {
        return this.list;
    }

    public T removeTail() {
        if (this.size > 0) {
            --this.size;
            return this.data[this.size];
        }
        throw new IllegalArgumentException("Size is already zero");
    }

    public T getTail() {
        return this.data[this.size - 1];
    }

    public void reset() {
        this.size = 0;
    }

    public int getMaxSize() {
        return this.data.length;
    }

    public int size() {
        return this.size;
    }

    public T get(int index) {
        if (index >= this.size) {
            throw new IllegalArgumentException("Index out of bounds");
        }
        return this.data[index];
    }

    public T grow() {
        if (this.size < this.data.length) {
            return this.data[this.size++];
        }
        this.growArray((this.data.length + 1) * 2);
        return this.data[this.size++];
    }

    public void add(T object) {
        if (this.size >= this.data.length) {
            this.growArray((this.data.length + 1) * 2);
        }
        this.data[this.size++] = object;
    }

    public void addAll(FastQueue<T> list) {
        for (int i = 0; i < list.size; ++i) {
            this.add(list.data[i]);
        }
    }

    public void growArray(int length) {
        if (this.data.length >= length) {
            return;
        }
        Object[] data = (Object[])Array.newInstance(this.type, length);
        System.arraycopy(this.data, 0, data, 0, this.data.length);
        if (this.declareInstances) {
            for (int i = this.data.length; i < length; ++i) {
                data[i] = this.createInstance();
            }
        }
        this.data = data;
    }

    protected T createInstance() {
        try {
            return this.type.newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> copyIntoList(List<T> ret) {
        if (ret == null) {
            ret = new ArrayList<T>(this.size);
        }
        for (int i = 0; i < this.size; ++i) {
            ret.add(this.data[i]);
        }
        return ret;
    }
}

