/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

import boofcv.struct.FastQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class FastQueueList<T>
implements List<T> {
    FastQueue<T> queue;

    public FastQueueList(FastQueue<T> queue) {
        this.queue = queue;
    }

    @Override
    public int size() {
        return this.queue.size;
    }

    @Override
    public boolean isEmpty() {
        return this.queue.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (int i = 0; i < this.queue.size; ++i) {
            if (!this.queue.data[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<T> iterator() {
        return new MyIterator();
    }

    @Override
    public Object[] toArray() {
        Object[] ret = new Object[this.queue.size];
        System.arraycopy(this.queue.data, 0, ret, 0, this.queue.size);
        return ret;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        System.arraycopy(this.queue.data, 0, a, 0, this.queue.size);
        return a;
    }

    @Override
    public boolean add(T t) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public boolean remove(Object o) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public void clear() {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public T get(int index) {
        return this.queue.data[index];
    }

    @Override
    public T set(int index, T element) {
        this.queue.data[index] = element;
        return this.queue.data[index];
    }

    @Override
    public void add(int index, T element) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public T remove(int index) {
        throw new RuntimeException("Not supported, FastQueue list interface is read only");
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.queue.size; ++i) {
            if (!this.queue.data[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.queue.size - 1; i >= 0; --i) {
            if (!this.queue.data[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new MyIterator();
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        throw new RuntimeException("Not supported");
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        throw new RuntimeException("Not supported");
    }

    public class MyIterator
    implements ListIterator<T> {
        int index = 0;

        @Override
        public boolean hasNext() {
            return this.index < FastQueueList.this.queue.size;
        }

        @Override
        public T next() {
            return FastQueueList.this.queue.data[this.index++];
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public T previous() {
            return FastQueueList.this.queue.data[--this.index];
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not supported, FastQueue list interface is read only");
        }

        @Override
        public void set(T t) {
            FastQueueList.this.queue.data[this.index - 1] = t;
        }

        @Override
        public void add(T t) {
            throw new RuntimeException("Not supported, FastQueue list interface is read only");
        }
    }
}

