/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct;

public class GrowQueue_F32 {
    public float[] data;
    public int size;

    public GrowQueue_F32(int maxSize) {
        this.data = new float[maxSize];
        this.size = 0;
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_F32 queue) {
        if (this.size + queue.size > this.data.length) {
            float[] temp = new float[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void add(float val) {
        this.push(val);
    }

    public void push(float val) {
        if (this.size == this.data.length) {
            float[] temp = new float[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public float get(int index) {
        return this.data[index];
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new float[size];
        }
        this.size = size;
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new float[size];
        }
    }

    public int getSize() {
        return this.size;
    }

    public float pop() {
        return this.data[--this.size];
    }
}

