/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageAccessException;
import boofcv.struct.image.ImageInterleaved;

public class ImageInterleavedInt8
extends ImageInterleaved<ImageInterleavedInt8> {
    public byte[] data;

    public ImageInterleavedInt8(int width, int height, int numBands) {
        super(width, height, numBands);
    }

    public ImageInterleavedInt8() {
    }

    public byte[] get(int x, int y, byte[] storage) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        if (storage == null) {
            storage = new byte[this.numBands];
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            storage[i] = this.data[index];
            ++i;
            ++index;
        }
        return storage;
    }

    public void set(int x, int y, byte ... value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds");
        }
        int index = this.getIndex(x, y, 0);
        int i = 0;
        while (i < this.numBands) {
            this.data[index] = value[i];
            ++i;
            ++index;
        }
    }

    public int getBand(int x, int y, int band) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        return this.data[this.getIndex(x, y, band)];
    }

    public void setBand(int x, int y, int band, byte value) {
        if (!this.isInBounds(x, y)) {
            throw new ImageAccessException("Requested pixel is out of bounds.");
        }
        if (band < 0 || band >= this.numBands) {
            throw new ImageAccessException("Invalid band requested.");
        }
        this.data[this.getIndex((int)x, (int)y, (int)band)] = value;
    }

    @Override
    public boolean isSubimage() {
        return this.startIndex != 0 || this.width * this.numBands != this.stride;
    }

    @Override
    protected Object _getData() {
        return this.data;
    }

    @Override
    protected Class getDataType() {
        return Byte.TYPE;
    }

    @Override
    protected void _setData(Object data) {
        this.data = (byte[])data;
    }

    @Override
    public ImageInterleavedInt8 _createNew(int imgWidth, int imgHeight) {
        if (imgWidth == -1 || imgHeight == -1) {
            return new ImageInterleavedInt8();
        }
        return new ImageInterleavedInt8(imgWidth, imgHeight, this.numBands);
    }
}

