/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.image;

import boofcv.struct.image.ImageFloat;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInt16;
import boofcv.struct.image.ImageInt8;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSInt8;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public final class ImageTypeInfo<T extends ImageSingleBand> {
    public static ImageTypeInfo<ImageUInt8> U8 = new ImageTypeInfo(false, Byte.TYPE, ImageUInt8.class);
    public static ImageTypeInfo<ImageSInt8> S8 = new ImageTypeInfo(true, Byte.TYPE, ImageSInt8.class);
    public static ImageTypeInfo<ImageUInt16> U16 = new ImageTypeInfo(false, Short.TYPE, ImageUInt16.class);
    public static ImageTypeInfo<ImageSInt16> S16 = new ImageTypeInfo(true, Short.TYPE, ImageSInt16.class);
    public static ImageTypeInfo<ImageSInt32> S32 = new ImageTypeInfo(true, Integer.TYPE, ImageSInt32.class);
    public static ImageTypeInfo<ImageSInt64> S64 = new ImageTypeInfo(true, Long.TYPE, ImageSInt64.class);
    public static ImageTypeInfo<ImageFloat32> F32 = new ImageTypeInfo(true, Float.TYPE, ImageFloat32.class);
    public static ImageTypeInfo<ImageFloat64> F64 = new ImageTypeInfo(true, Double.TYPE, ImageFloat64.class);
    public static ImageTypeInfo<ImageInt8> I8 = new ImageTypeInfo(Byte.TYPE, ImageInt8.class);
    public static ImageTypeInfo<ImageInt16> I16 = new ImageTypeInfo(Short.TYPE, ImageInt16.class);
    public static ImageTypeInfo<ImageInteger> I = new ImageTypeInfo(true, ImageInteger.class);
    public static ImageTypeInfo<ImageFloat> F = new ImageTypeInfo(true, ImageFloat.class);
    private int numBits;
    private boolean isAbstract;
    private boolean isSigned;
    private boolean isInteger;
    private double maxValue;
    private double minValue;
    private Class dataType;
    private Class sumType;
    private Class<T> imageClass;

    public static ImageTypeInfo classToType(Class imageClass) {
        if (imageClass == ImageUInt8.class) {
            return U8;
        }
        if (imageClass == ImageSInt8.class) {
            return S8;
        }
        if (imageClass == ImageUInt16.class) {
            return U16;
        }
        if (imageClass == ImageSInt16.class) {
            return S16;
        }
        if (imageClass == ImageSInt32.class) {
            return S32;
        }
        if (imageClass == ImageSInt64.class) {
            return S64;
        }
        if (imageClass == ImageFloat32.class) {
            return F32;
        }
        if (imageClass == ImageFloat64.class) {
            return F64;
        }
        if (imageClass == ImageInt8.class) {
            return I8;
        }
        if (imageClass == ImageInt16.class) {
            return I16;
        }
        if (imageClass == ImageInteger.class) {
            return I;
        }
        if (imageClass == ImageFloat.class) {
            return F;
        }
        throw new RuntimeException("Add");
    }

    ImageTypeInfo(boolean isInteger, Class imageClass) {
        this.isAbstract = true;
        this.isInteger = isInteger;
        this.imageClass = imageClass;
    }

    ImageTypeInfo(Class dataType, Class imageClass) {
        this.isAbstract = true;
        this.dataType = dataType;
        this.imageClass = imageClass;
        this.configureByDataType(dataType);
    }

    ImageTypeInfo(boolean isSigned, Class<?> dataType, Class imageClass) {
        this.isAbstract = false;
        this.isSigned = isSigned;
        this.dataType = dataType;
        this.imageClass = imageClass;
        this.configureByDataType(dataType);
    }

    private void configureByDataType(Class<?> dataType) {
        if (dataType == Float.TYPE || dataType == Double.TYPE) {
            this.sumType = dataType;
            this.isInteger = false;
            this.numBits = dataType == Float.TYPE ? 32 : 64;
        } else {
            this.isInteger = true;
            if (dataType == Byte.TYPE) {
                this.numBits = 8;
            } else if (dataType == Short.TYPE) {
                this.numBits = 16;
            } else if (dataType == Integer.TYPE) {
                this.numBits = 32;
            } else if (dataType == Long.TYPE) {
                this.numBits = 64;
            }
            this.sumType = this.numBits <= 32 ? Integer.TYPE : Long.TYPE;
        }
        this.configureMinMaxValues();
    }

    private void configureMinMaxValues() {
        if (this.isInteger) {
            switch (this.numBits) {
                case 8: {
                    this.minValue = -128.0;
                    this.maxValue = 127.0;
                    break;
                }
                case 16: {
                    this.minValue = -32768.0;
                    this.maxValue = 32767.0;
                    break;
                }
                case 32: {
                    this.minValue = -2.147483648E9;
                    this.maxValue = 2.147483647E9;
                    break;
                }
                case 64: {
                    this.minValue = -9.223372036854776E18;
                    this.maxValue = 9.223372036854776E18;
                }
            }
        } else {
            switch (this.numBits) {
                case 32: {
                    this.minValue = 1.4E-45f;
                    this.maxValue = 3.4028234663852886E38;
                    break;
                }
                case 64: {
                    this.minValue = Double.MIN_VALUE;
                    this.maxValue = Double.MAX_VALUE;
                }
            }
        }
        if (!this.isSigned) {
            this.maxValue += -this.minValue;
            this.minValue = 0.0;
        }
    }

    public int getNumBits() {
        return this.numBits;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isSigned() {
        return this.isSigned;
    }

    public boolean isInteger() {
        return this.isInteger;
    }

    public Class getDataType() {
        return this.dataType;
    }

    public Class getSumType() {
        return this.sumType;
    }

    public Class<T> getImageClass() {
        return this.imageClass;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.maxValue;
    }
}

