/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.pyramid;

import boofcv.core.image.ImageGenerator;
import boofcv.core.image.inst.FactoryImageGenerator;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;

public abstract class ImagePyramidBase<T extends ImageSingleBand>
implements ImagePyramid<T> {
    protected int bottomWidth;
    protected int bottomHeight;
    protected T[] layers;
    protected boolean saveOriginalReference;
    protected ImageGenerator<T> generator;

    public ImagePyramidBase(Class<T> imageType, boolean saveOriginalReference) {
        this.generator = FactoryImageGenerator.create(imageType);
        this.saveOriginalReference = saveOriginalReference;
    }

    protected void initialize(int width, int height) {
        if (this.bottomWidth == width && this.bottomHeight == height) {
            return;
        }
        this.bottomWidth = width;
        this.bottomHeight = height;
        this.layers = this.generator.createArray(this.getNumLayers());
        double scaleFactor = this.getScale(0);
        if (scaleFactor == 1.0) {
            if (!this.saveOriginalReference) {
                this.layers[0] = this.generator.createInstance(this.bottomWidth, this.bottomHeight);
            }
        } else {
            this.layers[0] = this.generator.createInstance((int)Math.ceil((double)this.bottomWidth / scaleFactor), (int)Math.ceil((double)this.bottomHeight / scaleFactor));
        }
        for (int i = 1; i < this.layers.length; ++i) {
            scaleFactor = this.getScale(i);
            this.layers[i] = this.generator.createInstance((int)Math.ceil((double)this.bottomWidth / scaleFactor), (int)Math.ceil((double)this.bottomHeight / scaleFactor));
        }
    }

    protected void checkScales() {
        if (this.getScale(0) < 0.0) {
            throw new IllegalArgumentException("The first layer must be more than zero.");
        }
        double prevScale = 0.0;
        for (int i = 0; i < this.getNumLayers(); ++i) {
            double s = this.getScale(i);
            if (s < prevScale) {
                throw new IllegalArgumentException("Higher layers must be the same size or larger than previous layers.");
            }
            prevScale = s;
        }
    }

    @Override
    public T getLayer(int layerNum) {
        return this.layers[layerNum];
    }

    public void setFirstLayer(T image) {
        if (!this.saveOriginalReference) {
            throw new IllegalArgumentException("Attempting to set the first layer when saveOriginalReference is false");
        }
        this.layers[0] = image;
    }

    @Override
    public int getWidth(int layer) {
        return ((ImageSingleBand)this.layers[layer]).width;
    }

    @Override
    public int getHeight(int layer) {
        return ((ImageSingleBand)this.layers[layer]).height;
    }

    @Override
    public Class<T> getImageType() {
        return this.generator.getType();
    }

    @Override
    public int getInputWidth() {
        return this.bottomWidth;
    }

    @Override
    public int getInputHeight() {
        return this.bottomHeight;
    }

    public boolean isSaveOriginalReference() {
        return this.saveOriginalReference;
    }
}

