/*
 * Decompiled with CFR 0.152.
 */
package adams.data.statistics;

import adams.data.statistics.AbstractDataStatistic;
import adams.data.statistics.StatUtils;
import adams.data.timeseries.Timeseries;
import adams.data.timeseries.TimeseriesPoint;
import java.util.List;

public class TimeseriesStatistic<T extends Timeseries>
extends AbstractDataStatistic<T> {
    private static final long serialVersionUID = -2482267274581297567L;

    public TimeseriesStatistic() {
    }

    public TimeseriesStatistic(T data) {
        super(data);
    }

    public String globalInfo() {
        return "Calculates a few statistics for a timeseries.";
    }

    public void cleanUp() {
        super.cleanUp();
        this.m_Data = null;
    }

    public void setData(T value) {
        this.m_Calculated = false;
        this.m_Data = value;
    }

    public T getData() {
        return (T)((Object)((Timeseries)this.m_Data));
    }

    public String getStatisticDescription() {
        return ((Timeseries)this.m_Data).getID() + " (" + ((Timeseries)this.m_Data).getDatabaseID() + ")";
    }

    protected void calculate() {
        super.calculate();
        if (this.m_Data == null) {
            return;
        }
        List points = ((Timeseries)this.m_Data).toList();
        Number[] values = new Double[]{};
        if (points.size() > 0) {
            values = new Double[points.size()];
            for (int i = 0; i < points.size(); ++i) {
                values[i] = ((TimeseriesPoint)((Object)points.get(i))).getValue();
            }
        }
        this.add("Database ID", ((Timeseries)this.m_Data).getDatabaseID());
        this.add("Number of points", points.size());
        this.add("min Value", ((Timeseries)this.m_Data).getMinValue() != null ? ((Timeseries)this.m_Data).getMinValue().getValue() : Double.NaN);
        this.add("max Value", ((Timeseries)this.m_Data).getMaxValue() != null ? ((Timeseries)this.m_Data).getMaxValue().getValue() : Double.NaN);
        this.add("mean Value", this.numberToDouble(StatUtils.mean((Number[])values)));
        this.add("stdev Value", this.numberToDouble(StatUtils.stddev((Number[])values, (boolean)true)));
        this.add("median Value", this.numberToDouble(StatUtils.median((Number[])values)));
        values = null;
    }
}

