/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.fourinone;

import adams.core.Index;
import adams.gui.core.BasePanel;
import adams.gui.visualization.stats.fourinone.VersusFit;
import adams.gui.visualization.stats.fourinone.VersusFitOptions;
import adams.gui.visualization.stats.fourinone.VersusOrder;
import adams.gui.visualization.stats.fourinone.VersusOrderOptions;
import adams.gui.visualization.stats.histogram.Histogram;
import adams.gui.visualization.stats.histogram.HistogramOptions;
import adams.gui.visualization.stats.probabilityplot.NormalPlot;
import adams.gui.visualization.stats.probabilityplot.NormalPlotOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import weka.core.Instances;
import weka.filters.Filter;
import weka.filters.unsupervised.attribute.AddExpression;

public class FourInOne
extends BasePanel {
    private static final long serialVersionUID = -993210228989776486L;
    protected Instances m_Instances;
    protected JPanel m_Centre;
    protected int m_Index;
    protected NormalPlotOptions m_NormOptions;
    protected HistogramOptions m_HistogramOptions;
    protected VersusFitOptions m_VsFitOptions;
    protected VersusOrderOptions m_VsOrderOptions;
    protected Index m_Act;
    protected Index m_Pred;
    protected int m_ActInd;
    protected int m_PredInd;

    public void setInstances(Instances val) {
        this.m_Instances = val;
    }

    protected void initGUI() {
        super.initGUI();
        this.setLayout(new BorderLayout());
        this.m_Centre = new JPanel();
        GridLayout gridLay = new GridLayout(2, 0);
        gridLay.setHgap(10);
        gridLay.setVgap(10);
        this.m_Centre.setLayout(gridLay);
        this.add(this.m_Centre, "Center");
    }

    public void reset() {
        this.m_Act.setMax(this.m_Instances.numAttributes());
        this.m_Pred.setMax(this.m_Instances.numAttributes());
        try {
            this.m_ActInd = this.m_Act.getIntIndex();
            if (this.m_ActInd == -1) {
                System.err.println("Error: default attribute used");
                this.m_ActInd = 0;
            }
        }
        catch (Exception e) {
            this.m_ActInd = 0;
            System.err.println("Error: default attribute used");
        }
        try {
            this.m_PredInd = this.m_Pred.getIntIndex();
            if (this.m_PredInd == -1) {
                System.err.println("Error: default attribute used");
                this.m_PredInd = 0;
            }
        }
        catch (Exception e) {
            this.m_PredInd = 0;
            System.err.println("Error: default attribute used");
        }
        JPanel normPanel = new JPanel(new BorderLayout());
        this.m_Centre.add(normPanel);
        JPanel vsFitPanel = new JPanel(new BorderLayout());
        this.m_Centre.add(vsFitPanel);
        JPanel histogramPanel = new JPanel(new BorderLayout());
        this.m_Centre.add(histogramPanel);
        JPanel vsOrderPanel = new JPanel(new BorderLayout());
        this.m_Centre.add(vsOrderPanel);
        AddExpression add = new AddExpression();
        add.setName("residuals");
        add.setExpression("a" + (this.m_ActInd + 1) + "-a" + (this.m_PredInd + 1));
        try {
            add.setInputFormat(this.m_Instances);
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        Instances theInst = new Instances("Empty", new ArrayList(), 0);
        try {
            theInst = Filter.useFilter((Instances)this.m_Instances, (Filter)add);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.m_Index = theInst.numAttributes() - 1;
        NormalPlot norm = new NormalPlot();
        norm.setInstances(theInst);
        norm.setIndex(this.m_Index);
        norm.setOptions(this.m_NormOptions);
        normPanel.add((Component)((Object)norm), "Center");
        JLabel normTitle = new JLabel("Normal Probability Plot");
        JPanel top = new JPanel(new FlowLayout());
        normPanel.add((Component)top, "North");
        top.add(normTitle);
        normPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        VersusFit vsFit = new VersusFit();
        vsFit.setInstances(theInst);
        vsFit.setIndices(this.m_Index, this.m_PredInd);
        vsFit.setOptions(this.m_VsFitOptions);
        vsFitPanel.add((Component)((Object)vsFit), "Center");
        JLabel vsFitTitle = new JLabel("Versus fit");
        top = new JPanel(new FlowLayout());
        vsFitPanel.add((Component)top, "North");
        top.add(vsFitTitle);
        vsFitPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        Histogram hist = new Histogram();
        hist.setInstances(theInst);
        hist.setOptions(this.m_HistogramOptions);
        hist.setIndex(this.m_Index);
        histogramPanel.add((Component)((Object)hist), "Center");
        JLabel histogramTitle = new JLabel("Histogram");
        top = new JPanel(new FlowLayout());
        histogramPanel.add((Component)top, "North");
        top.add(histogramTitle);
        histogramPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        VersusOrder VsOrder = new VersusOrder();
        VsOrder.setInstances(theInst);
        VsOrder.setIndex(this.m_Index);
        VsOrder.setOptions(this.m_VsOrderOptions);
        vsOrderPanel.add((Component)((Object)VsOrder), "Center");
        JLabel vsOrderTitle = new JLabel("Versus Order");
        top = new JPanel(new FlowLayout());
        vsOrderPanel.add((Component)top, "North");
        top.add((Component)vsOrderTitle, "Center");
        vsOrderPanel.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.m_Centre.repaint();
        this.m_Centre.revalidate();
        this.repaint();
    }

    public void setOptions(HistogramOptions hist, VersusFitOptions vsFit, VersusOrderOptions vsOrder, NormalPlotOptions norm) {
        this.m_HistogramOptions = hist;
        this.m_VsFitOptions = vsFit;
        this.m_VsOrderOptions = vsOrder;
        this.m_NormOptions = norm;
    }

    public void setAct(Index val) {
        this.m_Act = val;
    }

    public void setPred(Index val) {
        this.m_Pred = val;
    }
}

