/*
 * Decompiled with CFR 0.152.
 */
package adams.gui.visualization.stats.histogram;

import adams.data.DecimalFormatString;
import adams.gui.visualization.core.AxisPanelOptions;
import adams.gui.visualization.core.axis.FancyTickGenerator;
import adams.gui.visualization.core.axis.TickGenerator;
import adams.gui.visualization.core.axis.Type;
import adams.gui.visualization.stats.core.AbstractPlotOptionGroup;
import adams.gui.visualization.stats.paintlet.HistogramPaintlet;

public class HistogramOptions
extends AbstractPlotOptionGroup {
    private static final long serialVersionUID = -4737656972085433346L;
    protected int m_NumBins;
    protected double m_WidthBin;
    protected BoxType m_BoxType;
    protected HistogramPaintlet m_Val;

    protected String getGroupName() {
        return "Histogram plot";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("number-bins", "numberBins", (Object)10);
        this.m_OptionManager.add("width-bin", "widthBin", (Object)0.5);
        this.m_OptionManager.add("y-axis-type", "axisType", (Object)BoxType.DENSITY);
        this.m_OptionManager.add("paintlet", "paintlet", (Object)new HistogramPaintlet());
    }

    @Override
    protected AxisPanelOptions getDefaultAxisX() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(2);
        result.setWidth(40);
        result.setTopMargin(0.0);
        result.setBottomMargin(0.0);
        result.setCustomFormat(new DecimalFormatString("#.#"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(20);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    @Override
    protected AxisPanelOptions getDefaultAxisY() {
        AxisPanelOptions result = new AxisPanelOptions();
        result.setType(Type.ABSOLUTE);
        result.setLabel("");
        result.setShowGridLines(true);
        result.setLengthTicks(4);
        result.setNthValueToShow(1);
        result.setWidth(60);
        result.setTopMargin(0.05);
        result.setBottomMargin(0.0);
        result.setCustomFormat(new DecimalFormatString("#.#"));
        FancyTickGenerator tick = new FancyTickGenerator();
        tick.setNumTicks(10);
        result.setTickGenerator((TickGenerator)tick);
        return result;
    }

    public void setPaintlet(HistogramPaintlet val) {
        this.m_Val = val;
        this.reset();
    }

    public HistogramPaintlet getPaintlet() {
        return this.m_Val;
    }

    public String paintletTipText() {
        return "painlet for plotting the histogram plot";
    }

    public void setAxisType(BoxType val) {
        this.m_BoxType = val;
        this.reset();
    }

    public BoxType getAxisType() {
        return this.m_BoxType;
    }

    public String axisTypeTipText() {
        return "Axis type for y axis of the histogram";
    }

    public void setWidthBin(double val) {
        this.m_WidthBin = val;
        this.reset();
    }

    public double getWidthBin() {
        return this.m_WidthBin;
    }

    public String widthBinTipText() {
        return "Width of each bin, used only if denisty axis type chosen";
    }

    public void setNumberBins(int val) {
        this.m_NumBins = val;
        this.reset();
    }

    public int getNumberBins() {
        return this.m_NumBins;
    }

    public String numberBinsTipText() {
        return "Number of bins, used only if frequency axis type chosen";
    }

    public static enum BoxType {
        MANUAL,
        DENSITY;

    }
}

