/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.PopupUI;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.popup.JidePopup;
import com.jidesoft.swing.Gripper;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;

public class BasicJidePopupUI
extends PopupUI {
    protected JidePopup _popup;
    protected PropertyChangeListener _propertyChangeListener;
    protected LayoutManager _dockableFrameLayout;
    protected JComponent _northPane;
    protected JComponent _southPane;
    protected JComponent _westPane;
    protected JComponent _eastPane;
    protected Gripper _titlePane;
    private boolean keyBindingRegistered = false;
    private boolean keyBindingActive = false;

    public static ComponentUI createUI(JComponent b) {
        return new BasicJidePopupUI((JidePopup)b);
    }

    public BasicJidePopupUI() {
    }

    public BasicJidePopupUI(JidePopup f) {
        this._popup = f;
    }

    public void installUI(JComponent c) {
        this._popup = (JidePopup)c;
        this.installDefaults();
        this.installListeners();
        this.installComponents();
        this.installKeyboardActions();
        this._popup.setOpaque(true);
    }

    public void uninstallUI(JComponent c) {
        if (c != this._popup) {
            throw new IllegalComponentStateException(this + " was asked to deinstall() " + c + " when it only knows about " + this._popup + ".");
        }
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallDefaults();
        this._popup = null;
    }

    protected void installDefaults() {
        Color bg;
        JComponent contentPane = (JComponent)this._popup.getContentPane();
        if (contentPane != null && (bg = contentPane.getBackground()) instanceof UIResource) {
            contentPane.setBackground(null);
        }
        this._dockableFrameLayout = this.createLayoutManager();
        this._popup.setLayout(this._dockableFrameLayout);
        this._popup.setBackground(UIDefaultsLookup.getColor("JideButton.background"));
        LookAndFeel.installBorder(this._popup, "Popup.border");
    }

    protected void installKeyboardActions() {
        ActionMap actionMap = this.getActionMap();
        SwingUtilities.replaceUIActionMap(this._popup, actionMap);
    }

    ActionMap getActionMap() {
        ActionMap map = (ActionMap)UIDefaultsLookup.get("Popup.actionMap");
        if (map == null && (map = this.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("Popup.actionMap", map);
        }
        return map;
    }

    ActionMap createActionMap() {
        ActionMapUIResource map = new ActionMapUIResource();
        return map;
    }

    protected void installComponents() {
        this.setNorthPane(this.createNorthPane(this._popup));
        this.setSouthPane(this.createSouthPane(this._popup));
        this.setEastPane(this.createEastPane(this._popup));
        this.setWestPane(this.createWestPane(this._popup));
    }

    protected void installListeners() {
        this._propertyChangeListener = this.createPropertyChangeListener();
        this._popup.addPropertyChangeListener(this._propertyChangeListener);
    }

    InputMap getInputMap(int condition) {
        if (condition == 2) {
            return this.createInputMap(condition);
        }
        return null;
    }

    InputMap createInputMap(int condition) {
        Object[] bindings;
        if (condition == 2 && (bindings = (Object[])UIDefaultsLookup.get("Popup.windowBindings")) != null) {
            return LookAndFeel.makeComponentInputMap(this._popup, bindings);
        }
        return null;
    }

    protected void uninstallDefaults() {
        this._dockableFrameLayout = null;
        this._popup.setLayout(null);
        LookAndFeel.uninstallBorder(this._popup);
    }

    protected void uninstallComponents() {
        this.setNorthPane(null);
        this.setSouthPane(null);
        this.setEastPane(null);
        this.setWestPane(null);
        this._titlePane = null;
    }

    protected void uninstallListeners() {
        this._popup.removePropertyChangeListener(this._propertyChangeListener);
        this._propertyChangeListener = null;
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIInputMap(this._popup, 2, null);
        SwingUtilities.replaceUIActionMap(this._popup, null);
    }

    public Component getGripper() {
        return this._titlePane;
    }

    protected LayoutManager createLayoutManager() {
        return new PopupLayout();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PopupPropertyChangeListener();
    }

    public Dimension getPreferredSize(JComponent x) {
        if (this._popup == x && this._popup.getLayout() != null) {
            return this._popup.getLayout().preferredLayoutSize(x);
        }
        return new Dimension(100, 100);
    }

    public Dimension getMinimumSize(JComponent x) {
        if (this._popup == x) {
            return this._popup.getLayout().minimumLayoutSize(x);
        }
        return new Dimension(0, 0);
    }

    public Dimension getMaximumSize(JComponent x) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    protected void replacePane(JComponent currentPane, JComponent newPane) {
        if (currentPane != null) {
            this.deinstallMouseHandlers(currentPane);
            this._popup.remove(currentPane);
        }
        if (newPane != null) {
            this._popup.add(newPane);
            this.installMouseHandlers(newPane);
        }
    }

    protected void deinstallMouseHandlers(JComponent c) {
    }

    protected void installMouseHandlers(JComponent c) {
    }

    protected JComponent createNorthPane(JidePopup w) {
        if (w.getGripperLocation() == 1 && w.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createSouthPane(JidePopup w) {
        if (w.getGripperLocation() == 5 && w.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(1);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createWestPane(JidePopup w) {
        if (w.getGripperLocation() == 7 && w.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected JComponent createEastPane(JidePopup w) {
        if (w.getGripperLocation() == 3 && w.isMovable()) {
            this._titlePane = new Gripper();
            this._titlePane.setOrientation(0);
            this._titlePane.setRolloverEnabled(true);
            this._titlePane.setOpaque(true);
            return this._titlePane;
        }
        return null;
    }

    protected final boolean isKeyBindingRegistered() {
        return this.keyBindingRegistered;
    }

    protected final void setKeyBindingRegistered(boolean b) {
        this.keyBindingRegistered = b;
    }

    public final boolean isKeyBindingActive() {
        return this.keyBindingActive;
    }

    protected final void setKeyBindingActive(boolean b) {
        this.keyBindingActive = b;
    }

    protected void setupMenuOpenKey() {
        InputMap map = this.getInputMap(2);
        SwingUtilities.replaceUIInputMap(this._popup, 2, map);
    }

    protected void setupMenuCloseKey() {
    }

    public JComponent getNorthPane() {
        return this._northPane;
    }

    protected void setNorthPane(JComponent c) {
        this.replacePane(this._northPane, c);
        this._northPane = c;
    }

    public JComponent getSouthPane() {
        return this._southPane;
    }

    protected void setSouthPane(JComponent c) {
        this.replacePane(this._southPane, c);
        this._southPane = c;
    }

    public JComponent getWestPane() {
        return this._westPane;
    }

    protected void setWestPane(JComponent c) {
        this.replacePane(this._westPane, c);
        this._westPane = c;
    }

    public JComponent getEastPane() {
        return this._eastPane;
    }

    protected void setEastPane(JComponent c) {
        this.replacePane(this._eastPane, c);
        this._eastPane = c;
    }

    public class PopupLayout
    implements LayoutManager {
        public void addLayoutComponent(String name, Component c) {
        }

        public void removeLayoutComponent(Component c) {
        }

        public Dimension preferredLayoutSize(Container c) {
            Dimension d;
            Insets i = BasicJidePopupUI.this._popup.getInsets();
            Dimension result = new Dimension(BasicJidePopupUI.this._popup.getRootPane().getPreferredSize());
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                d = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                d = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                result.width = Math.max(d.width, result.width);
                result.height += d.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                d = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                d = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                result.width += d.width;
                result.height = Math.max(d.height, result.height);
            }
            return result;
        }

        public Dimension minimumLayoutSize(Container c) {
            Dimension minimumSize;
            Dimension result = new Dimension();
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                result = new Dimension(BasicJidePopupUI.this.getNorthPane().getMinimumSize());
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                minimumSize = BasicJidePopupUI.this.getSouthPane().getMinimumSize();
                result.width = Math.max(result.width, minimumSize.width);
                result.height += minimumSize.height;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                minimumSize = BasicJidePopupUI.this.getEastPane().getMinimumSize();
                result.width += minimumSize.width;
                result.height = Math.max(result.height, minimumSize.height);
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                minimumSize = BasicJidePopupUI.this.getWestPane().getMinimumSize();
                result.width = Math.max(result.width, minimumSize.width);
                result.height += minimumSize.height;
            }
            Dimension alter = BasicJidePopupUI.this._popup.getContentPane().getMinimumSize();
            if (alter.width > result.width) {
                result.width = alter.width;
            }
            result.height += alter.height;
            Insets i = BasicJidePopupUI.this._popup.getInsets();
            result.width += i.left + i.right;
            result.height += i.top + i.bottom;
            return result;
        }

        public void layoutContainer(Container c) {
            Dimension size;
            Insets i = BasicJidePopupUI.this._popup.getInsets();
            int cx = i.left;
            int cy = i.top;
            int cw = BasicJidePopupUI.this._popup.getWidth() - i.left - i.right;
            int ch = BasicJidePopupUI.this._popup.getHeight() - i.top - i.bottom;
            if (BasicJidePopupUI.this.getNorthPane() != null) {
                BasicJidePopupUI.this.getNorthPane().setVisible(true);
                size = BasicJidePopupUI.this.getNorthPane().getPreferredSize();
                BasicJidePopupUI.this.getNorthPane().setBounds(cx, cy, cw, size.height);
                cy += size.height;
                ch -= size.height;
            }
            if (BasicJidePopupUI.this.getSouthPane() != null) {
                size = BasicJidePopupUI.this.getSouthPane().getPreferredSize();
                BasicJidePopupUI.this.getSouthPane().setBounds(cx, BasicJidePopupUI.this._popup.getHeight() - i.bottom - size.height, cw, size.height);
                ch -= size.height;
            }
            if (BasicJidePopupUI.this.getWestPane() != null) {
                size = BasicJidePopupUI.this.getWestPane().getPreferredSize();
                BasicJidePopupUI.this.getWestPane().setBounds(cx, cy, size.width, ch);
                cw -= size.width;
                cx += size.width;
            }
            if (BasicJidePopupUI.this.getEastPane() != null) {
                size = BasicJidePopupUI.this.getEastPane().getPreferredSize();
                BasicJidePopupUI.this.getEastPane().setBounds(cw - size.width, cy, size.width, ch);
                cw -= size.width;
            }
            if (BasicJidePopupUI.this._popup.getRootPane() != null) {
                BasicJidePopupUI.this._popup.getRootPane().setBounds(cx, cy, cw, ch);
            }
        }
    }

    public class PopupPropertyChangeListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            String prop = evt.getPropertyName();
            JidePopup f = (JidePopup)evt.getSource();
            Object newValue = evt.getNewValue();
            Object oldValue = evt.getOldValue();
            if ("movable".equals(prop)) {
                f.updateUI();
            }
            if ("gripperLocation".equals(prop)) {
                f.updateUI();
            }
        }
    }
}

