/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.DateFormat;
import adams.core.QuickInfoHelper;
import adams.core.TechnicalInformation;
import adams.core.TechnicalInformationHandler;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import twitter4j.Status;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class TwitterConverter
extends AbstractTransformer
implements TechnicalInformationHandler {
    private static final long serialVersionUID = -4249772734326614365L;
    public static final String BACKUP_HEADER = "header";
    protected OutputType m_OutputType;
    protected TwitterField[] m_Fields;
    protected String m_Separator;
    protected boolean m_Quote;
    protected Instances m_Header;
    protected String m_DateFormat;
    protected transient DateFormat m_DateFormatter;

    public String globalInfo() {
        return "Turns a Twitter tweet or status into different representation.\nPlease note that tweet and status objects differ in what fields are available:\n- tweet-specific: " + (Object)((Object)TwitterField.LANGUAGE_CODE) + "\n" + "- status-specific: " + (Object)((Object)TwitterField.PLACE) + ", " + (Object)((Object)TwitterField.COUNTRY) + ", " + (Object)((Object)TwitterField.COUNTRY_CODE) + "\n" + "Also, GEO location data might not be available.\n" + "For more information on the date format, see:\n" + this.getTechnicalInformation().toString();
    }

    public TechnicalInformation getTechnicalInformation() {
        return new DateFormat().getTechnicalInformation();
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-type", "outputType", (Object)OutputType.STRING);
        this.m_OptionManager.add("field", "fields", (Object)new TwitterField[]{TwitterField.TEXT});
        this.m_OptionManager.add("separator", "separator", (Object)"\t");
        this.m_OptionManager.add("quote", "quote", (Object)false);
        this.m_OptionManager.add("date-format", "dateFormat", (Object)"yyyy-MM-dd HH:mm:ss");
    }

    protected void initialize() {
        super.initialize();
        this.m_Header = null;
        this.m_DateFormatter = null;
    }

    public void setOutputType(OutputType value) {
        this.m_OutputType = value;
        this.reset();
    }

    public OutputType getOutputType() {
        return this.m_OutputType;
    }

    public String outputTypeTipText() {
        return "The type of output to generate.";
    }

    public void setFields(TwitterField[] value) {
        this.m_Fields = value;
        this.reset();
    }

    public TwitterField[] getFields() {
        return this.m_Fields;
    }

    public String fieldsTipText() {
        return "The fields to use for generating the output.";
    }

    public void setSeparator(String value) {
        this.m_Separator = Utils.unbackQuoteChars((String)value);
        this.reset();
    }

    public String getSeparator() {
        return Utils.backQuoteChars((String)this.m_Separator);
    }

    public String separatorTipText() {
        return "The separator to use when generating strings as output; tab, new line, carriage return and backslash need to be escaped, ie, '\t', '\n', '\r', '\\'.";
    }

    public void setQuote(boolean value) {
        this.m_Quote = value;
        this.reset();
    }

    public boolean getQuote() {
        return this.m_Quote;
    }

    public String quoteTipText() {
        return "If enabled all sub-strings are quoted if necessary when generating string output.";
    }

    public void setDateFormat(String value) {
        this.m_DateFormat = value;
        this.reset();
    }

    public String getDateFormat() {
        return this.m_DateFormat;
    }

    public String dateFormatTipText() {
        return "The format for the dates.";
    }

    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, (String)"outputType", (Object)((Object)this.m_OutputType));
        result = result + QuickInfoHelper.toString((OptionHandler)this, (String)"fields", (Object)Utils.flatten((Object[])this.m_Fields, (String)", "), (String)": ");
        return result;
    }

    public Class[] accepts() {
        return new Class[]{Status.class};
    }

    public Class[] generates() {
        switch (this.m_OutputType) {
            case STRING: {
                return new Class[]{String.class};
            }
            case INSTANCE: {
                return new Class[]{Instance.class};
            }
        }
        throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
    }

    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_HEADER);
    }

    protected Hashtable<String, Object> backupState() {
        Hashtable result = super.backupState();
        if (this.m_Header != null) {
            result.put(BACKUP_HEADER, this.m_Header);
        }
        return result;
    }

    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_HEADER)) {
            this.m_Header = (Instances)state.get(BACKUP_HEADER);
            state.remove(BACKUP_HEADER);
        }
        super.restoreState(state);
    }

    protected DateFormat getDateFormatter() {
        if (this.m_DateFormatter == null) {
            this.m_DateFormatter = new DateFormat(this.m_DateFormat);
            this.m_DateFormatter.setLenient(false);
        }
        return this.m_DateFormatter;
    }

    protected void generateHeader() {
        if (this.m_Header != null) {
            return;
        }
        ArrayList<Attribute> atts = new ArrayList<Attribute>();
        block5: for (int i = 0; i < this.m_Fields.length; ++i) {
            switch (this.m_Fields[i]) {
                case ID: 
                case USER_ID: 
                case GEO_LATITUDE: 
                case GEO_LONGITUDE: {
                    atts.add(new Attribute(this.m_Fields[i].toString()));
                    continue block5;
                }
                case USER_NAME: 
                case SOURCE: 
                case TEXT: 
                case LANGUAGE_CODE: 
                case PLACE: 
                case COUNTRY: 
                case COUNTRY_CODE: {
                    atts.add(new Attribute(this.m_Fields[i].toString(), (List)null));
                    continue block5;
                }
                case CREATED: {
                    atts.add(new Attribute(this.m_Fields[i].toString(), this.m_DateFormat));
                }
            }
        }
        this.m_Header = new Instances(this.getName(), atts, 0);
    }

    protected Hashtable<TwitterField, Object> processStatus(Status status) {
        Hashtable<TwitterField, Object> result = new Hashtable<TwitterField, Object>();
        result.put(TwitterField.ID, status.getId());
        result.put(TwitterField.USER_ID, status.getUser().getId());
        result.put(TwitterField.USER_NAME, status.getUser().getName());
        result.put(TwitterField.SOURCE, status.getSource());
        result.put(TwitterField.TEXT, status.getText());
        result.put(TwitterField.CREATED, this.getDateFormatter().format(status.getCreatedAt()));
        if (status.getGeoLocation() != null) {
            result.put(TwitterField.GEO_LATITUDE, status.getGeoLocation().getLatitude());
            result.put(TwitterField.GEO_LONGITUDE, status.getGeoLocation().getLongitude());
        }
        if (status.getPlace() != null) {
            if (status.getPlace().getCountryCode() != null) {
                result.put(TwitterField.COUNTRY_CODE, status.getPlace().getCountryCode());
            }
            if (status.getPlace().getCountry() != null) {
                result.put(TwitterField.COUNTRY, status.getPlace().getCountry());
            }
            if (status.getPlace().getName() != null) {
                result.put(TwitterField.PLACE, status.getPlace().getName());
            }
        }
        return result;
    }

    protected Token processFields(Hashtable<TwitterField, Object> fields) {
        Token result;
        switch (this.m_OutputType) {
            case STRING: {
                StringBuilder str = new StringBuilder();
                for (int i = 0; i < this.m_Fields.length; ++i) {
                    Object obj;
                    if (i > 0) {
                        str.append(this.m_Separator);
                    }
                    if ((obj = fields.get((Object)this.m_Fields[i])) == null) {
                        str.append("?");
                        continue;
                    }
                    if (this.m_Quote) {
                        str.append(Utils.quote((String)("" + obj)));
                        continue;
                    }
                    str.append("" + obj);
                }
                result = new Token((Object)str.toString());
                break;
            }
            case INSTANCE: {
                this.generateHeader();
                DenseInstance inst = new DenseInstance(this.m_Header.numAttributes());
                inst.setDataset(this.m_Header);
                block14: for (int i = 0; i < this.m_Fields.length; ++i) {
                    Object obj;
                    Attribute att = this.m_Header.attribute(this.m_Fields[i].toString());
                    if (att == null || (obj = fields.get((Object)this.m_Fields[i])) == null) continue;
                    switch (this.m_Fields[i]) {
                        case ID: {
                            inst.setValue(att, ((Long)obj).doubleValue());
                            continue block14;
                        }
                        case USER_ID: {
                            inst.setValue(att, ((Integer)obj).doubleValue());
                            continue block14;
                        }
                        case USER_NAME: 
                        case SOURCE: 
                        case TEXT: 
                        case LANGUAGE_CODE: 
                        case PLACE: 
                        case COUNTRY: 
                        case COUNTRY_CODE: {
                            inst.setValue(att, (String)obj);
                            continue block14;
                        }
                        case CREATED: {
                            try {
                                inst.setValue(att, (double)this.m_DateFormatter.parse((String)obj).getTime());
                            }
                            catch (Exception e) {
                                this.handleException("Failed to parse date '" + obj + "' with pattern " + "'" + this.m_DateFormat + "':", e);
                            }
                            continue block14;
                        }
                        case GEO_LATITUDE: 
                        case GEO_LONGITUDE: {
                            inst.setValue(att, ((Double)obj).doubleValue());
                        }
                    }
                }
                result = new Token((Object)inst);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled output type: " + (Object)((Object)this.m_OutputType));
            }
        }
        return result;
    }

    protected String doExecute() {
        String result = null;
        try {
            Hashtable<TwitterField, Object> fields = this.processStatus((Status)this.m_InputToken.getPayload());
            this.m_OutputToken = this.processFields(fields);
        }
        catch (Exception e) {
            result = this.handleException("Failed to process fields: " + Utils.arrayToString((Object)this.m_Fields), e);
        }
        return result;
    }

    public static enum TwitterField {
        ID,
        USER_ID,
        USER_NAME,
        SOURCE,
        TEXT,
        CREATED,
        GEO_LATITUDE,
        GEO_LONGITUDE,
        LANGUAGE_CODE,
        PLACE,
        COUNTRY,
        COUNTRY_CODE;

    }

    public static enum OutputType {
        STRING,
        INSTANCE;

    }
}

