/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.combinatorics;

import java.util.ArrayList;
import java.util.List;

public class Permute<T> {
    protected List<T> list;
    private int[] bins;
    protected int N;
    private int end;

    public Permute(List<T> list) {
        this.init(list);
    }

    public Permute() {
    }

    private void init(List<T> list) {
        int i;
        this.list = list;
        this.bins = new int[list.size() + 1];
        for (i = 0; i < this.bins.length; ++i) {
            this.bins[i] = i;
        }
        this.N = 1;
        this.end = 1;
        for (i = 1; i < this.bins.length; ++i) {
            this.end *= i;
        }
    }

    public int getTotalPermutations() {
        return this.end;
    }

    public boolean next() {
        if (this.bins[this.N] >= this.list.size()) {
            return false;
        }
        int n = this.N;
        this.bins[n] = this.bins[n] - 1;
        int j = this.N % 2 * this.bins[this.N];
        this.swap(this.N, j);
        this.N = 1;
        while (this.bins[this.N] == 0) {
            this.bins[this.N] = this.N;
            ++this.N;
        }
        return true;
    }

    private void swap(int a, int b) {
        if (a > b) {
            int t = a;
            a = b;
            b = t;
        }
        T t = this.list.get(a);
        this.list.set(a, this.list.get(b));
        this.list.set(b, t);
    }

    public boolean previous() {
        int i;
        if (this.N == 1) {
            for (i = 0; i < this.bins.length; ++i) {
                if (this.bins[i] == i) continue;
                int n = i;
                this.bins[n] = this.bins[n] + 1;
                this.N = i;
                break;
            }
            if (this.N == 1) {
                return false;
            }
        } else {
            for (i = 2; i < this.N; ++i) {
                this.bins[i] = 0;
            }
            this.N = 1;
        }
        int j = this.N % 2 * (this.bins[this.N] - 1);
        this.swap(this.N, j);
        return true;
    }

    public int size() {
        return this.list.size();
    }

    public T get(int i) {
        return this.list.get(this.bins[i]);
    }

    public List<T> getAll(List<T> storage) {
        if (storage == null) {
            storage = new ArrayList<T>();
        } else {
            storage.clear();
        }
        for (int i = 0; i < this.list.size(); ++i) {
            storage.add(this.get(i));
        }
        return storage;
    }
}

