/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.ExhaustiveNeighbor;

public class WrapExhaustiveNeighbor<D>
implements NearestNeighbor<D> {
    ExhaustiveNeighbor alg = new ExhaustiveNeighbor();
    List<double[]> points;
    List<D> data;

    @Override
    public void init(int N) {
        this.alg.setN(N);
    }

    @Override
    public void setPoints(List<double[]> points, List<D> data) {
        this.alg.setPoints(points);
        this.points = points;
        this.data = data;
    }

    @Override
    public boolean findNearest(double[] point, double maxDistance, NnData<D> result) {
        int index;
        if (maxDistance <= 0.0) {
            maxDistance = Double.MAX_VALUE;
        }
        if ((index = this.alg.findClosest(point, maxDistance)) >= 0) {
            result.point = this.points.get(index);
            result.distance = this.alg.getBestDistance();
            if (this.data != null) {
                result.data = this.data.get(index);
            }
            return true;
        }
        return false;
    }
}

