/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.transformer;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractTransformer;
import com.itextpdf.text.Document;
import com.itextpdf.text.pdf.PdfCopy;
import com.itextpdf.text.pdf.PdfReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

public class PDFMerge
extends AbstractTransformer {
    private static final long serialVersionUID = 5783362940767103716L;
    protected PlaceholderFile m_Output;

    public String globalInfo() {
        return "Actor for merging multiple PDF files.\nForwards the name of the generated file.";
    }

    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output", "output", (Object)new PlaceholderFile("."));
    }

    public void setOutput(PlaceholderFile value) {
        this.m_Output = value;
        this.reset();
    }

    public PlaceholderFile getOutput() {
        return this.m_Output;
    }

    public String outputTipText() {
        return "The PDF file to merge the input files into.";
    }

    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, (String)"output", (Object)this.m_Output);
    }

    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    public Class[] generates() {
        return new Class[]{String.class};
    }

    protected String doExecute() {
        int i;
        String result = null;
        File[] files = null;
        if (this.m_InputToken.getPayload() instanceof File) {
            files = new File[]{(File)this.m_InputToken.getPayload()};
        } else if (this.m_InputToken.getPayload() instanceof File[]) {
            files = (File[])this.m_InputToken.getPayload();
        } else if (this.m_InputToken.getPayload() instanceof String) {
            files = new File[]{new PlaceholderFile((String)this.m_InputToken.getPayload())};
        } else if (this.m_InputToken.getPayload() instanceof String[]) {
            files = new File[((String[])this.m_InputToken.getPayload()).length];
            for (i = 0; i < files.length; ++i) {
                files[i] = new PlaceholderFile(((String[])this.m_InputToken.getPayload())[i]);
            }
        }
        try {
            if (this.isLoggingEnabled()) {
                this.getLogger().info("Merging PDFs into: " + this.m_Output);
            }
            Document document = new Document();
            PdfCopy copy = new PdfCopy(document, (OutputStream)new FileOutputStream(this.m_Output.getAbsolutePath()));
            document.open();
            document.addCreationDate();
            document.addCreator(Environment.getInstance().getProject());
            document.addAuthor(System.getProperty("user.name"));
            for (i = 0; i < files.length; ++i) {
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("Adding file: " + files[i]);
                }
                PdfReader reader = new PdfReader(files[i].getAbsolutePath());
                int pages = reader.getNumberOfPages();
                if (this.isLoggingEnabled()) {
                    this.getLogger().info("- #pages: " + pages);
                }
                for (int n = 1; n <= pages; ++n) {
                    copy.addPage(copy.getImportedPage(reader, n));
                    if (!this.isLoggingEnabled()) continue;
                    this.getLogger().info("- adding page: " + n);
                }
                copy.freeReader(reader);
            }
            document.close();
        }
        catch (Exception e) {
            result = this.handleException("Failed to merge PDF files: ", e);
        }
        if (result == null) {
            this.m_OutputToken = new Token((Object)this.m_Output.getAbsolutePath());
        }
        return result;
    }
}

