/*
 * Decompiled with CFR 0.152.
 */
package adams.core;

import adams.core.AbstractPersistentHistory;
import adams.core.Utils;
import adams.core.io.FileUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class StringHistory
extends AbstractPersistentHistory<String> {
    private static final long serialVersionUID = -5716154035144840331L;

    @Override
    protected String copy(String obj) {
        return new String(obj);
    }

    @Override
    protected boolean save() {
        if (this.m_HistoryFile.isDirectory()) {
            return false;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String item : this.m_History) {
            list.add(Utils.backQuoteChars(item));
        }
        return FileUtils.saveToFile(list, (File)this.m_HistoryFile);
    }

    @Override
    protected boolean load() {
        if (this.m_HistoryFile.isDirectory()) {
            return false;
        }
        if (!this.m_HistoryFile.exists()) {
            return false;
        }
        List<String> list = FileUtils.loadFromFile(this.m_HistoryFile);
        if (list != null) {
            this.m_History.clear();
            for (String item : list) {
                this.m_History.add(Utils.unbackQuoteChars(item));
            }
        }
        return list != null;
    }
}

