/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractCommandLineHandler;
import adams.core.option.AbstractRecursiveOptionProducer;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.core.option.OptionUtils;
import adams.core.option.RecursiveOptionProducer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;

public class ArrayProducer
extends AbstractRecursiveOptionProducer<String[], ArrayList<String>>
implements RecursiveOptionProducer {
    private static final long serialVersionUID = 2014571979604068762L;
    protected ArrayList<String> m_OutputList;

    @Override
    public String globalInfo() {
        return "Generates a string array that can be used on the command-line.";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_OutputList = new ArrayList();
    }

    @Override
    protected String[] initOutput() {
        return new String[0];
    }

    @Override
    public ArrayList<String> processOption(BooleanOption option) {
        return this.processOption((AbstractArgumentOption)option);
    }

    @Override
    public ArrayList<String> processOption(AbstractArgumentOption option) {
        ArrayList<String> result = new ArrayList<String>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        result.add(this.getOptionIdentifier(option));
                        result.add(option.toString(Array.get(currValues, i)));
                    }
                }
            }
        }
        if (this.m_Nesting.empty()) {
            this.m_OutputList.addAll(result);
        } else {
            ((ArrayList)this.m_Nesting.peek()).addAll(result);
        }
        return result;
    }

    @Override
    public ArrayList<String> processOption(ClassOption option) {
        ArrayList<String> result = new ArrayList<String>();
        if (option.isVariableAttached() && !this.m_OutputVariableValues) {
            result.add(this.getOptionIdentifier(option));
            result.add(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            if (!this.isDefaultValue(option, currValue)) {
                Object currValues = null;
                if (currValue != null) {
                    if (!option.isMultiple()) {
                        currValues = Array.newInstance(option.getBaseClass(), 1);
                        Array.set(currValues, 0, currValue);
                    } else {
                        currValues = currValue;
                    }
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        result.add(this.getOptionIdentifier(option));
                        ArrayList<String> nested = new ArrayList<String>();
                        nested.add(value.getClass().getName());
                        if (value instanceof OptionHandler) {
                            this.m_Nesting.push(nested);
                            this.doProduce(((OptionHandler)value).getOptionManager());
                            this.m_Nesting.pop();
                        } else {
                            AbstractCommandLineHandler handler = AbstractCommandLineHandler.getHandler(value);
                            nested.addAll(Arrays.asList(handler.getOptions(value)));
                        }
                        result.add(OptionUtils.joinOptions(nested.toArray(new String[nested.size()])));
                    }
                }
            }
        }
        if (result.size() > 0) {
            if (this.m_Nesting.empty()) {
                this.m_OutputList.addAll(result);
            } else {
                ((ArrayList)this.m_Nesting.peek()).addAll(result);
            }
        }
        return result;
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_Output = null;
        this.m_OutputList.clear();
        this.m_OutputList.add(this.m_Input.getClass().getName());
    }

    @Override
    public String[] getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputList.toArray(new String[this.m_OutputList.size()]);
        }
        return (String[])this.m_Output;
    }

    @Override
    public String toString() {
        return OptionUtils.joinOptions(this.getOutput());
    }

    @Override
    public void cleanUp() {
        super.cleanUp();
        this.m_OutputList = null;
    }

    public static String[] getOptions(OptionHandler handler) {
        ArrayProducer producer = new ArrayProducer();
        producer.produce(handler);
        String[] tmp = producer.getOutput();
        String[] result = new String[tmp.length - 1];
        System.arraycopy(tmp, 1, result, 0, tmp.length - 1);
        return result;
    }

    public static void main(String[] args) {
        ArrayProducer.runProducer(ArrayProducer.class, args);
    }
}

