/*
 * Decompiled with CFR 0.152.
 */
package adams.core.option;

import adams.core.io.FileFormatHandler;
import adams.core.net.HtmlUtils;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractRecursiveOptionProducerWithOptionHandling;
import adams.core.option.BooleanOption;
import adams.core.option.ClassOption;
import adams.core.option.OptionHandler;
import adams.env.Environment;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractGlobalActor;
import adams.flow.core.GlobalActorUser;
import java.lang.reflect.Array;
import java.util.Hashtable;

public class FlowStructureGraphMLProducer
extends AbstractRecursiveOptionProducerWithOptionHandling<String, String>
implements FileFormatHandler {
    private static final long serialVersionUID = -1493427064082222688L;
    protected boolean m_OutputClassname;
    protected boolean m_LinkGlobalActors;
    protected boolean m_OutputYEdGraphML;
    protected StringBuilder m_OutputBuffer;
    protected int m_NodeCounter;
    protected int m_EdgeCounter;
    protected Hashtable<String, String> m_NameIDRelation;

    @Override
    public String globalInfo() {
        return "Outputs the flow structure in GraphML XML format.\n\nFor more information on the GraphML format, see:\nhttp://en.wikipedia.org/wiki/GraphML";
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_UsePropertyNames = true;
        this.m_NameIDRelation = new Hashtable();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("output-classname", "outputClassname", false);
        this.m_OptionManager.add("link-global-actors", "linkGlobalActors", false);
        this.m_OptionManager.add("output-yed-graphml", "outputYEdGraphML", false);
    }

    @Override
    protected String initOutput() {
        return "";
    }

    @Override
    public String outputVariableValuesTipText() {
        return "This option is ignored, since only the structure is output.";
    }

    public void setOutputClassname(boolean value) {
        this.m_OutputClassname = value;
        this.reset();
    }

    public boolean getOutputClassname() {
        return this.m_OutputClassname;
    }

    public String outputClassnameTipText() {
        return "Whether to output the classnames in the labels as well.";
    }

    public void setLinkGlobalActors(boolean value) {
        this.m_LinkGlobalActors = value;
        this.reset();
    }

    public boolean getLinkGlobalActors() {
        return this.m_LinkGlobalActors;
    }

    public String linkGlobalActorsTipText() {
        return "Whether to output the links to global actors as well.";
    }

    public void setOutputYEdGraphML(boolean value) {
        this.m_OutputYEdGraphML = value;
        this.reset();
    }

    public boolean getOutputYEdGraphML() {
        return this.m_OutputYEdGraphML;
    }

    public String outputYEdGraphMLTipText() {
        return "Whether to output yEd GraphML.";
    }

    @Override
    public String processOption(BooleanOption option) {
        return null;
    }

    protected String nextNodeID() {
        ++this.m_NodeCounter;
        return "n" + this.m_NodeCounter;
    }

    protected String nextEdgeID() {
        ++this.m_EdgeCounter;
        return "e" + this.m_EdgeCounter;
    }

    protected void addEdge(String from, String to) {
        this.m_OutputBuffer.append("  <edge");
        this.m_OutputBuffer.append(" id=\"" + this.nextEdgeID() + "\"");
        this.m_OutputBuffer.append(" directed=\"true\"");
        this.m_OutputBuffer.append(" source=\"" + this.sanitize(from) + "\"");
        this.m_OutputBuffer.append(" target=\"" + this.sanitize(to) + "\"");
        this.m_OutputBuffer.append("/>\n");
    }

    protected String sanitize(String label) {
        return HtmlUtils.toHTML(label);
    }

    protected void addNode(String id, String label) {
        this.m_OutputBuffer.append("  <node id=\"" + this.sanitize(id) + "\">\n");
        if (this.m_OutputYEdGraphML) {
            this.m_OutputBuffer.append("    <data key=\"d0\">\n");
            this.m_OutputBuffer.append("      <y:ShapeNode>\n");
            this.m_OutputBuffer.append("        <y:NodeLabel>" + this.sanitize(label) + "</y:NodeLabel>\n");
            this.m_OutputBuffer.append("      </y:ShapeNode>\n");
            this.m_OutputBuffer.append("    </data>\n");
        } else {
            this.m_OutputBuffer.append("    <data key=\"d0\">" + this.sanitize(label) + "</data>\n");
        }
        this.m_OutputBuffer.append("  </node>\n");
    }

    protected String addNode(AbstractActor actor) {
        String result = this.nextNodeID();
        if (this.m_Nesting.size() > 0) {
            this.addEdge((String)this.m_Nesting.peek(), result);
        }
        String label = actor.getName();
        if (this.m_OutputClassname) {
            label = label + "\n[" + actor.getClass().getName().replaceFirst("^.*\\.flow\\.", "") + "]";
        }
        if (actor instanceof GlobalActorUser) {
            if (this.m_LinkGlobalActors) {
                String globalID;
                AbstractActor globalActor = ((GlobalActorUser)((Object)actor)).getGlobalActor();
                if (globalActor != null && (globalID = this.m_NameIDRelation.get(globalActor.getFullName())) != null) {
                    this.addEdge(result, globalID);
                }
            } else {
                label = label + ": " + ((AbstractGlobalActor)actor).getGlobalName();
            }
        }
        this.addNode(result, label);
        this.m_NameIDRelation.put(actor.getFullName(), result);
        return result;
    }

    protected String addVariableNode(String variable) {
        String result = this.nextNodeID();
        if (this.m_Nesting.size() > 0) {
            this.addEdge((String)this.m_Nesting.peek(), result);
        }
        this.addNode(result, variable);
        return result;
    }

    @Override
    public String processOption(ClassOption option) {
        if (!AbstractActor.class.isAssignableFrom(option.getBaseClass())) {
            return null;
        }
        if (option.isVariableAttached()) {
            this.addVariableNode(option.getVariable());
        } else {
            Object currValue = this.getCurrentValue(option);
            Object currValues = null;
            if (currValue != null) {
                if (!option.isMultiple()) {
                    Object value = currValue;
                    AbstractActor actor = (AbstractActor)value;
                    String id = this.addNode(actor);
                    this.m_Nesting.push(id);
                    this.doProduce(((OptionHandler)value).getOptionManager());
                } else {
                    currValues = currValue;
                    int size = this.m_Nesting.size();
                    for (int i = 0; i < Array.getLength(currValues); ++i) {
                        Object value = Array.get(currValues, i);
                        AbstractActor actor = (AbstractActor)value;
                        String id = this.addNode(actor);
                        this.m_Nesting.push(id);
                        this.doProduce(((OptionHandler)value).getOptionManager());
                        this.m_Nesting.pop();
                    }
                    while (this.m_Nesting.size() > size) {
                        this.m_Nesting.pop();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public String processOption(AbstractArgumentOption option) {
        return null;
    }

    @Override
    protected OptionHandler checkInput(OptionHandler object) {
        OptionHandler result = super.checkInput(object);
        if (!(result instanceof AbstractActor)) {
            throw new IllegalArgumentException("Input object must be derived from " + AbstractActor.class.getName());
        }
        return result;
    }

    @Override
    protected void preProduce() {
        super.preProduce();
        this.m_NodeCounter = 0;
        this.m_EdgeCounter = 0;
        this.m_Output = null;
        this.m_OutputBuffer = new StringBuilder();
        this.m_OutputBuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.m_OutputBuffer.append("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns\"\n");
        this.m_OutputBuffer.append("    xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"\n");
        if (this.m_OutputYEdGraphML) {
            this.m_OutputBuffer.append("    xmlns:y=\"http://www.yworks.com/xml/graphml\"\n");
        }
        this.m_OutputBuffer.append("    xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns http://graphml.graphdrawing.org/xmlns/1.0/graphml.xsd\">\n");
        if (this.m_OutputYEdGraphML) {
            this.m_OutputBuffer.append("  <key id=\"d0\" for=\"node\" yfiles.type=\"nodegraphics\"/>\n");
        } else {
            this.m_OutputBuffer.append("  <key id=\"d0\" for=\"node\" attr.name=\"label\" attr.type=\"string\"/>\n");
        }
        this.m_OutputBuffer.append("  <graph id=\"" + Environment.getInstance().getProject() + "\" edgedefault=\"directed\">\n");
        AbstractActor actor = (AbstractActor)this.getInput();
        actor.setUp();
        String id = this.addNode(actor);
        this.m_Nesting.push(id);
    }

    @Override
    protected void postProduce() {
        super.postProduce();
        this.m_OutputBuffer.append("  </graph>\n");
        this.m_OutputBuffer.append("</graphml>\n");
        AbstractActor actor = (AbstractActor)this.getInput();
        actor.wrapUp();
        actor.cleanUp();
    }

    @Override
    public String getOutput() {
        if (this.m_Output == null) {
            this.m_Output = this.m_OutputBuffer.toString();
        }
        return (String)this.m_Output;
    }

    @Override
    public String toString() {
        return this.getOutput();
    }

    @Override
    public String getFormatDescription() {
        return "GraphML XML format";
    }

    @Override
    public String getDefaultFormatExtension() {
        return "graphml";
    }

    @Override
    public String[] getFormatExtensions() {
        return new String[]{this.getDefaultFormatExtension()};
    }

    public static void main(String[] args) {
        FlowStructureGraphMLProducer.runProducer(FlowStructureGraphMLProducer.class, args);
    }
}

