/*
 * Decompiled with CFR 0.152.
 */
package adams.data.baseline;

import adams.core.TechnicalInformation;
import adams.data.baseline.AbstractBaselineCorrection;
import adams.data.container.DataContainer;
import adams.data.container.DataPoint;
import adams.data.filter.AbstractSavitzkyGolay;

public abstract class AbstractSavitzkyGolayBased<T extends DataContainer>
extends AbstractBaselineCorrection<T> {
    private static final long serialVersionUID = 1662223546956780389L;
    protected AbstractSavitzkyGolay m_Filter;

    @Override
    public String globalInfo() {
        return "A baseline correction scheme that uses SavitzkyGolay smoothing to determine the baseline.\n\nFor more information see:\n\n" + this.getTechnicalInformation().toString();
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("polynomial", "polynomialOrder", 2, 2, null);
        this.m_OptionManager.add("left", "numPointsLeft", 3, 0, null);
        this.m_OptionManager.add("right", "numPointsRight", 3, 0, null);
    }

    public TechnicalInformation getTechnicalInformation() {
        return this.getFilter().getTechnicalInformation();
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Filter = this.getFilter();
    }

    protected abstract AbstractSavitzkyGolay getFilter();

    public void setPolynomialOrder(int value) {
        this.m_Filter.setPolynomialOrder(value);
    }

    public int getPolynomialOrder() {
        return this.m_Filter.getPolynomialOrder();
    }

    public String polynomialOrderTipText() {
        return this.m_Filter.polynomialOrderTipText();
    }

    public void setNumPointsLeft(int value) {
        this.m_Filter.setNumPointsLeft(value);
    }

    public int getNumPointsLeft() {
        return this.m_Filter.getNumPointsLeft();
    }

    public String numPointsLeftTipText() {
        return this.m_Filter.numPointsLeftTipText();
    }

    public void setNumPointsRight(int value) {
        this.m_Filter.setNumPointsRight(value);
    }

    public int getNumPointsRight() {
        return this.m_Filter.getNumPointsRight();
    }

    public String numPointsRightTipText() {
        return this.m_Filter.numPointsRightTipText();
    }

    protected abstract DataPoint getOriginalPoint(DataPoint var1, T var2);

    protected abstract DataPoint subtract(DataPoint var1, DataPoint var2);

    @Override
    protected T processData(T data) {
        T filtered = this.m_Filter.filter(data);
        DataContainer result = data.getHeader();
        for (int i = 0; i < filtered.size(); ++i) {
            DataPoint oldPoint = this.getOriginalPoint((DataPoint)data.toList().get(i), data);
            DataPoint newPoint = this.subtract(oldPoint, (DataPoint)filtered.toList().get(i));
            result.add(newPoint);
        }
        return (T)result;
    }
}

