/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.data.conversion.AbstractConversion;
import adams.data.conversion.ConversionWithInitialization;

public abstract class AbstractScriptedConversion
extends AbstractConversion
implements ConversionWithInitialization,
FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -8187233244973711251L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "scriptFile", new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim(), null);
    }

    @Override
    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    @Override
    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    @Override
    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    @Override
    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    @Override
    public String setUp() {
        return this.initScriptObject();
    }

    @Override
    public boolean requiresSetUp() {
        return this.m_ScriptObject == null;
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ScriptObject = null;
    }
}

