/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.DateTimeType;
import adams.core.Time;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversion;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class ExtractDateTimeField
extends AbstractConversion {
    private static final long serialVersionUID = 6801095206203068066L;
    public static final String SUNDAY = "Sunday";
    public static final String MONDAY = "Monday";
    public static final String TUESDAY = "Tuesday";
    public static final String WEDNESDAY = "Wednesday";
    public static final String THURSDAY = "Thursday";
    public static final String FRIDAY = "Friday";
    public static final String SATURDAY = "Saturday";
    protected DateTimeType m_DateTimeType;
    protected DateTimeField m_Field;
    protected DateFormatString m_FormatCustom;
    protected transient DateFormat m_FormatterCustom;
    protected transient DateFormat m_FormatterDayOfWeek;
    protected Calendar m_Calendar;

    @Override
    public String globalInfo() {
        return "Extracts the specified field from a date/time type.\nA custom format string can be used with field " + (Object)((Object)DateTimeField.CUSTOM) + ".";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)DateTimeType.DATE);
        this.m_OptionManager.add("field", "field", (Object)DateTimeField.YEAR);
        this.m_OptionManager.add("format-custom", "formatCustom", new DateFormatString("yyyy-MM-dd"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Calendar = new GregorianCalendar();
        this.m_FormatterDayOfWeek = new DateFormat("E");
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_FormatterCustom = null;
    }

    public void setDateTimeType(DateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public DateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "The date/time type to extract the field from.";
    }

    public void setField(DateTimeField value) {
        this.m_Field = value;
        this.reset();
    }

    public DateTimeField getField() {
        return this.m_Field;
    }

    public String fieldTipText() {
        return "The field to extract.";
    }

    public void setFormatCustom(DateFormatString value) {
        this.m_FormatCustom = value;
        this.reset();
    }

    public DateFormatString getFormatCustom() {
        return this.m_FormatCustom;
    }

    public String formatCustomTipText() {
        return "The format for turning the date/time type into a string in case of field " + (Object)((Object)DateTimeField.CUSTOM);
    }

    @Override
    public Class accepts() {
        switch (this.m_DateTimeType) {
            case MSECS: {
                return Double.class;
            }
            case SECONDS: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case TIME: {
                return Time.class;
            }
            case BASEDATE: {
                return BaseDate.class;
            }
            case BASEDATETIME: {
                return BaseDateTime.class;
            }
            case BASETIME: {
                return BaseTime.class;
            }
        }
        throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
    }

    @Override
    public Class generates() {
        switch (this.m_Field) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: 
            case MSEC: 
            case WEEK_OF_YEAR: 
            case WEEK_OF_MONTH: 
            case DAY_OF_YEAR: 
            case DAY_OF_WEEK: 
            case DAY_OF_MONTH: {
                return Integer.class;
            }
            case DAY_OF_WEEK_STR_EN: 
            case DAY_OF_WEEK_STR_LOCALE: 
            case CUSTOM: {
                return String.class;
            }
        }
        throw new IllegalStateException("Unhandled field: " + (Object)((Object)this.m_Field));
    }

    @Override
    protected Object doConvert() throws Exception {
        switch (this.m_DateTimeType) {
            case MSECS: {
                this.m_Calendar.setTime(new Date(((Double)this.m_Input).longValue()));
                break;
            }
            case SECONDS: {
                this.m_Calendar.setTime(new Date(((Double)this.m_Input).longValue() * 1000L));
                break;
            }
            case DATE: {
                this.m_Calendar.setTime((Date)this.m_Input);
                break;
            }
            case DATETIME: {
                this.m_Calendar.setTime((DateTime)this.m_Input);
                break;
            }
            case TIME: {
                this.m_Calendar.setTime((Time)this.m_Input);
                break;
            }
            case BASEDATE: {
                this.m_Calendar.setTime(((BaseDate)this.m_Input).dateValue());
                break;
            }
            case BASEDATETIME: {
                this.m_Calendar.setTime(((BaseDateTime)this.m_Input).dateValue());
                break;
            }
            case BASETIME: {
                this.m_Calendar.setTime(((BaseTime)this.m_Input).dateValue());
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
            }
        }
        switch (this.m_Field) {
            case YEAR: {
                return this.m_Calendar.get(1);
            }
            case MONTH: {
                return this.m_Calendar.get(2) + 1;
            }
            case DAY: {
                return this.m_Calendar.get(6);
            }
            case HOUR: {
                return this.m_Calendar.get(10);
            }
            case MINUTE: {
                return this.m_Calendar.get(12);
            }
            case SECOND: {
                return this.m_Calendar.get(13);
            }
            case MSEC: {
                return this.m_Calendar.get(14);
            }
            case WEEK_OF_YEAR: {
                return this.m_Calendar.get(3);
            }
            case WEEK_OF_MONTH: {
                return this.m_Calendar.get(4);
            }
            case DAY_OF_YEAR: {
                return this.m_Calendar.get(6);
            }
            case DAY_OF_MONTH: {
                return this.m_Calendar.get(5);
            }
            case DAY_OF_WEEK: {
                return this.m_Calendar.get(7);
            }
            case DAY_OF_WEEK_STR_EN: {
                int day = this.m_Calendar.get(7);
                switch (day) {
                    case 1: {
                        return SUNDAY;
                    }
                    case 2: {
                        return MONDAY;
                    }
                    case 3: {
                        return TUESDAY;
                    }
                    case 4: {
                        return WEDNESDAY;
                    }
                    case 5: {
                        return THURSDAY;
                    }
                    case 6: {
                        return FRIDAY;
                    }
                    case 7: {
                        return SATURDAY;
                    }
                }
                return null;
            }
            case DAY_OF_WEEK_STR_LOCALE: {
                return this.m_FormatterDayOfWeek.format(this.m_Calendar.getTime());
            }
            case CUSTOM: {
                if (this.m_FormatterCustom == null) {
                    this.m_FormatterCustom = this.m_FormatCustom.toDateFormat();
                }
                return this.m_FormatterCustom.format(this.m_Calendar.getTime());
            }
        }
        throw new IllegalStateException("Unhandled field: " + (Object)((Object)this.m_Field));
    }

    public static enum DateTimeField {
        YEAR,
        MONTH,
        DAY,
        HOUR,
        MINUTE,
        SECOND,
        MSEC,
        DAY_OF_YEAR,
        DAY_OF_MONTH,
        DAY_OF_WEEK,
        DAY_OF_WEEK_STR_EN,
        DAY_OF_WEEK_STR_LOCALE,
        WEEK_OF_YEAR,
        WEEK_OF_MONTH,
        CUSTOM;

    }
}

