/*
 * Decompiled with CFR 0.152.
 */
package adams.data.conversion;

import adams.core.DateFormat;
import adams.core.DateTime;
import adams.core.DateTimeType;
import adams.core.Time;
import adams.core.base.BaseDate;
import adams.core.base.BaseDateTime;
import adams.core.base.BaseTime;
import adams.data.DateFormatString;
import adams.data.conversion.AbstractConversionFromString;
import java.util.Date;

public class StringToDateTimeType
extends AbstractConversionFromString {
    private static final long serialVersionUID = -2353313471489671117L;
    protected DateTimeType m_DateTimeType;
    protected DateFormatString m_Format;
    protected boolean m_UseBaseParsing;
    protected transient DateFormat m_Formatter;

    @Override
    public String globalInfo() {
        return "Parses a string and turns it into an instance of the the specified date/time type. The string may contain variables, which get expanded at conversion time.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("format", "format", new DateFormatString("yyyy-MM-dd"));
        this.m_OptionManager.add("datetime-type", "dateTimeType", (Object)DateTimeType.DATE);
        this.m_OptionManager.add("use-base-parsing", "useBaseParsing", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Formatter = null;
    }

    public void setFormat(DateFormatString value) {
        this.m_Format = value;
        this.reset();
    }

    public DateFormatString getFormat() {
        return this.m_Format;
    }

    public String formatTipText() {
        return "The format for parsing the date/time string.";
    }

    public void setDateTimeType(DateTimeType value) {
        this.m_DateTimeType = value;
        this.reset();
    }

    public DateTimeType getDateTimeType() {
        return this.m_DateTimeType;
    }

    public String dateTimeTypeTipText() {
        return "The date/time type to generate from the string.";
    }

    public void setUseBaseParsing(boolean value) {
        this.m_UseBaseParsing = value;
        this.reset();
    }

    public boolean getUseBaseParsing() {
        return this.m_UseBaseParsing;
    }

    public String useBaseParsingTipText() {
        return "If enabled, uses the parsing capability of the BaseTime, BaseDate, BaseDateTime classes to parse the string rather than the specified format string (string must be in the appropriate format).";
    }

    @Override
    public Class generates() {
        switch (this.m_DateTimeType) {
            case MSECS: {
                return Double.class;
            }
            case SECONDS: {
                return Double.class;
            }
            case DATE: {
                return Date.class;
            }
            case DATETIME: {
                return DateTime.class;
            }
            case TIME: {
                return Time.class;
            }
            case BASEDATE: {
                return BaseDate.class;
            }
            case BASEDATETIME: {
                return BaseDateTime.class;
            }
            case BASETIME: {
                return BaseTime.class;
            }
        }
        throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
    }

    @Override
    protected Object doConvert() throws Exception {
        try {
            String input = (String)this.m_Input;
            input = this.getOptionManager().getVariables().expand(input);
            Date date = null;
            if (this.m_UseBaseParsing) {
                switch (this.m_DateTimeType) {
                    case BASEDATE: {
                        date = new BaseDate(input).dateValue();
                        break;
                    }
                    case BASEDATETIME: {
                        date = new BaseDateTime(input).dateValue();
                        break;
                    }
                    case BASETIME: {
                        date = new BaseTime(input).dateValue();
                        break;
                    }
                    default: {
                        date = null;
                    }
                }
            }
            if (date == null) {
                if (this.m_Formatter == null) {
                    this.m_Formatter = this.m_Format.toDateFormat();
                }
                date = this.m_Formatter.parse(input);
            }
            switch (this.m_DateTimeType) {
                case MSECS: {
                    return new Double(date.getTime());
                }
                case SECONDS: {
                    return new Double(date.getTime() / 1000L);
                }
                case DATE: {
                    return date;
                }
                case DATETIME: {
                    return new DateTime(date);
                }
                case TIME: {
                    return new Time(date);
                }
                case BASEDATE: {
                    return new BaseDate(date);
                }
                case BASEDATETIME: {
                    return new BaseDateTime(date);
                }
                case BASETIME: {
                    return new BaseTime(date);
                }
            }
            throw new IllegalStateException("Unhandled data/time type: " + (Object)((Object)this.m_DateTimeType));
        }
        catch (Exception e) {
            throw new Exception("Failed to parse: " + this.m_Input, e);
        }
    }
}

