/*
 * Decompiled with CFR 0.152.
 */
package adams.data.filter;

import adams.core.ClassLister;
import adams.core.CleanUpHandler;
import adams.core.Performance;
import adams.core.ShallowCopySupporter;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionUtils;
import adams.data.NotesHandler;
import adams.data.container.DataContainer;
import adams.data.id.DatabaseIDHandler;
import adams.data.id.IDHandler;
import adams.multiprocess.Job;
import adams.multiprocess.JobList;
import adams.multiprocess.JobRunner;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilter<T extends DataContainer>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler,
ShallowCopySupporter<AbstractFilter> {
    private static final long serialVersionUID = 3610605513320220903L;
    protected boolean m_DontUpdateID;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("no-id-update", "dontUpdateID", false);
    }

    public void setDontUpdateID(boolean value) {
        this.m_DontUpdateID = value;
        this.reset();
    }

    public boolean getDontUpdateID() {
        return this.m_DontUpdateID;
    }

    public String dontUpdateIDTipText() {
        return "If enabled, suppresses updating the ID of " + IDHandler.class.getName() + " data containers.";
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void cleanUp() {
        this.reset();
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }

    public T filter(T data) {
        this.checkData(data);
        T result = this.processData(data);
        if (!this.m_DontUpdateID && result instanceof IDHandler) {
            result.setID(result.getID() + "'");
        }
        if (result instanceof NotesHandler) {
            ((NotesHandler)result).getNotes().addProcessInformation(this);
        }
        return result;
    }

    protected void checkData(T data) {
        if (data == null) {
            throw new IllegalStateException("No input data provided!");
        }
    }

    protected abstract T processData(T var1);

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    @Override
    public AbstractFilter shallowCopy() {
        return this.shallowCopy(false);
    }

    @Override
    public AbstractFilter shallowCopy(boolean expand) {
        return (AbstractFilter)OptionUtils.shallowCopy(this, expand);
    }

    public static String[] getFilters() {
        return ClassLister.getSingleton().getClassnames(AbstractFilter.class);
    }

    public static AbstractFilter forName(String classname, String[] options) {
        AbstractFilter result;
        try {
            result = (AbstractFilter)OptionUtils.forName(AbstractFilter.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static AbstractFilter forCommandLine(String cmdline) {
        return (AbstractFilter)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static DataContainer filter(AbstractFilter filter, DataContainer data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.add(data);
        ArrayList<AbstractFilter> filterList = new ArrayList<AbstractFilter>();
        filterList.add(filter);
        List<List<DataContainer>> filtered = AbstractFilter.filter(filterList, dataList);
        DataContainer result = filtered.get(0).get(0);
        return result;
    }

    public static List<DataContainer> filter(AbstractFilter filter, List<DataContainer> data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.addAll(data);
        ArrayList<AbstractFilter> filterList = new ArrayList<AbstractFilter>();
        filterList.add(filter);
        List<List<DataContainer>> filtered = AbstractFilter.filter(filterList, dataList);
        List<DataContainer> result = filtered.get(0);
        return result;
    }

    public static List<DataContainer> filter(List<AbstractFilter> filter, DataContainer data) {
        ArrayList<DataContainer> dataList = new ArrayList<DataContainer>();
        dataList.add(data);
        ArrayList<AbstractFilter> filterList = new ArrayList<AbstractFilter>();
        filterList.addAll(filter);
        List<List<DataContainer>> filtered = AbstractFilter.filter(filterList, dataList);
        ArrayList<DataContainer> result = new ArrayList<DataContainer>();
        for (int i = 0; i < filtered.size(); ++i) {
            result.add(filtered.get(i).get(0));
        }
        return result;
    }

    public static List<List<DataContainer>> filter(List<AbstractFilter> filter, List<DataContainer> data) {
        ArrayList<List<DataContainer>> result = new ArrayList<List<DataContainer>>();
        if (Performance.getMultiProcessingEnabled()) {
            int i;
            JobRunner runner = new JobRunner();
            JobList<FilterJob<DataContainer>> jobs = new JobList<FilterJob<DataContainer>>();
            for (int n = 0; n < filter.size(); ++n) {
                for (i = 0; i < data.size(); ++i) {
                    AbstractFilter threadFilter = filter.get(n).shallowCopy(true);
                    jobs.add(new FilterJob<DataContainer>(threadFilter, data.get(i)));
                }
            }
            runner.add(jobs);
            runner.start();
            runner.stop();
            ArrayList<Object> subresult = null;
            for (i = 0; i < jobs.size(); ++i) {
                FilterJob job;
                if (i % data.size() == 0) {
                    subresult = new ArrayList<Object>();
                    result.add(subresult);
                }
                if ((job = (FilterJob)jobs.get(i)).getFilteredData() != null) {
                    subresult.add(job.getFilteredData());
                } else {
                    subresult.add(job.getData().getHeader());
                }
                job.cleanUp();
            }
        } else {
            for (int n = 0; n < filter.size(); ++n) {
                ArrayList<DataContainer> subresult = new ArrayList<DataContainer>();
                result.add(subresult);
                for (int i = 0; i < data.size(); ++i) {
                    AbstractFilter threadFilter = filter.get(n).shallowCopy(true);
                    subresult.add(threadFilter.filter(data.get(i)));
                }
            }
        }
        return result;
    }

    public static class FilterJob<T extends DataContainer>
    extends Job {
        private static final long serialVersionUID = 5544327082749651329L;
        protected AbstractFilter m_Filter;
        protected T m_Data;
        protected T m_FilteredData;

        public FilterJob(AbstractFilter filter, T data) {
            this.m_Filter = filter;
            this.m_Data = data;
            this.m_FilteredData = null;
        }

        public AbstractFilter getFilter() {
            return this.m_Filter;
        }

        public T getData() {
            return this.m_Data;
        }

        public T getFilteredData() {
            return this.m_FilteredData;
        }

        @Override
        protected String preProcessCheck() {
            if (this.m_Filter == null) {
                return "No filter set!";
            }
            if (this.m_Data == null) {
                return "No data set!";
            }
            return null;
        }

        @Override
        protected void process() throws Exception {
            this.m_FilteredData = this.m_Filter.filter(this.m_Data);
        }

        @Override
        protected String postProcessCheck() {
            if (this.m_FilteredData == null) {
                return "Result of filter is null!";
            }
            return null;
        }

        @Override
        public void cleanUp() {
            super.cleanUp();
            this.m_Filter.destroy();
            this.m_Filter = null;
            this.m_FilteredData = null;
            this.m_Data = null;
        }

        @Override
        protected String getAdditionalErrorInformation() {
            if (this.m_Data instanceof NotesHandler) {
                return ((NotesHandler)this.m_Data).getNotes().toString();
            }
            return "";
        }

        @Override
        public String toString() {
            String result = "data:" + this.m_Data.getID() + ", ";
            if (this.m_Data instanceof DatabaseIDHandler) {
                result = result + "db-id: " + ((DatabaseIDHandler)this.m_Data).getDatabaseID() + ", ";
            }
            result = result + "filter: " + OptionUtils.getCommandLine(this.m_Filter);
            return result;
        }
    }
}

