/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.CloneHandler;
import adams.data.MutableNotesHandler;
import adams.data.Notes;
import adams.data.report.DataType;
import adams.data.report.Field;
import adams.data.report.MutableReportHandler;
import adams.data.report.Report;
import java.awt.image.BufferedImage;

public abstract class AbstractImage<T>
implements CloneHandler<AbstractImage<T>>,
MutableNotesHandler,
MutableReportHandler<Report> {
    public static final String FIELD_FILENAME = "Filename";
    protected T m_Image;
    protected Report m_Report;
    protected Notes m_Notes;

    protected AbstractImage() {
        this.initialize();
    }

    protected void initialize() {
        this.m_Image = null;
        this.m_Notes = new Notes();
        this.m_Report = new Report();
        this.m_Report.addField(new Field(FIELD_FILENAME, DataType.STRING));
    }

    protected abstract T cloneImage();

    @Override
    public AbstractImage<T> getClone() {
        AbstractImage<T> result = this.getHeader();
        result.setImage(this.cloneImage());
        return result;
    }

    public AbstractImage<T> getHeader() {
        AbstractImage result;
        try {
            result = (AbstractImage)this.getClass().newInstance();
            result.setReport(this.getReport().getClone());
            result.m_Notes = this.getNotes().getClone();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        return result;
    }

    public void setImage(T value) {
        if (value == null) {
            throw new IllegalArgumentException("Null image provided!");
        }
        this.m_Image = value;
    }

    public T getImage() {
        return this.m_Image;
    }

    public abstract int getWidth();

    public abstract int getHeight();

    @Override
    public boolean hasReport() {
        return this.m_Report != null;
    }

    @Override
    public void setReport(Report value) {
        this.m_Report = value;
    }

    @Override
    public Report getReport() {
        return this.m_Report;
    }

    public void setNotes(Notes value) {
        this.m_Notes = value;
    }

    @Override
    public Notes getNotes() {
        return this.m_Notes;
    }

    public abstract BufferedImage toBufferedImage();

    public String toString() {
        return "image=" + this.m_Image + ", report=" + this.m_Report + ", notes=" + this.m_Notes;
    }
}

