/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.CleanUpHandler;
import adams.core.option.AbstractOptionHandler;
import adams.core.option.OptionUtils;
import adams.data.image.AbstractImage;

public abstract class AbstractImageTransformer<T extends AbstractImage>
extends AbstractOptionHandler
implements Comparable,
CleanUpHandler {
    private static final long serialVersionUID = 4566948525813804085L;

    protected void checkImage(T img) {
        if (img == null) {
            throw new IllegalStateException("No image provided!");
        }
    }

    protected abstract T[] doTransform(T var1);

    public T[] transform(T img) {
        this.checkImage(img);
        AbstractImage[] result = this.doTransform((AbstractImage)((AbstractImage)img).getClone());
        for (int i = 0; i < result.length; ++i) {
            result[i].getNotes().addProcessInformation(this);
        }
        return result;
    }

    public int compareTo(Object o) {
        if (o == null) {
            return 1;
        }
        return OptionUtils.getCommandLine(this).compareTo(OptionUtils.getCommandLine(o));
    }

    public boolean equals(Object o) {
        return this.compareTo(o) == 0;
    }

    public T shallowCopy() {
        return this.shallowCopy(false);
    }

    public T shallowCopy(boolean expand) {
        return (T)((AbstractImage)((Object)OptionUtils.shallowCopy(this, expand)));
    }

    @Override
    public void cleanUp() {
    }

    @Override
    public void destroy() {
        this.cleanUp();
        super.destroy();
    }
}

