/*
 * Decompiled with CFR 0.152.
 */
package adams.data.image;

import adams.core.Properties;
import adams.data.conversion.DOMToProperties;
import adams.data.image.BufferedImageContainer;
import adams.data.report.Report;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.FileInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;

public class BufferedImageHelper {
    public static BufferedImage deepCopy(BufferedImage img) {
        ColorModel cm = img.getColorModel();
        boolean isAlphaPremultiplied = cm.isAlphaPremultiplied();
        WritableRaster raster = img.copyData(null);
        return new BufferedImage(cm, raster, isAlphaPremultiplied, null);
    }

    public static int[] getPixels(BufferedImage img) {
        int[] result = new int[img.getWidth() * img.getHeight()];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[i] = img.getRGB(x, y);
                ++i;
            }
        }
        return result;
    }

    public static int[][] getRGBPixels(BufferedImage img) {
        int[][] result = new int[img.getWidth() * img.getHeight()][4];
        int i = 0;
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                int pixel = img.getRGB(x, y);
                result[i][0] = pixel >> 16 & 0xFF;
                result[i][1] = pixel >> 8 & 0xFF;
                result[i][2] = pixel >> 0 & 0xFF;
                result[i][3] = pixel >> 24 & 0xFF;
                ++i;
            }
        }
        return result;
    }

    public static int[][] getPixelRaster(BufferedImage img) {
        int[][] result = new int[img.getHeight()][img.getWidth()];
        for (int y = 0; y < img.getHeight(); ++y) {
            for (int x = 0; x < img.getWidth(); ++x) {
                result[y][x] = img.getRGB(x, y);
            }
        }
        return result;
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, Color targetColor, Color replacementColor) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor.getRGB(), replacementColor.getRGB());
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, int targetColor, int replacementColor) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor, replacementColor, new int[4]);
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, Color targetColor, Color replacementColor, int[] extent) {
        return BufferedImageHelper.floodFill(img, startX, startY, targetColor.getRGB(), replacementColor.getRGB(), extent);
    }

    public static boolean floodFill(BufferedImage img, int startX, int startY, int targetColor, int replacementColor, int[] extent) {
        if (img.getRGB(startX, startY) != targetColor) {
            extent[0] = -1;
            extent[1] = -1;
            extent[2] = -1;
            extent[3] = -1;
            return false;
        }
        extent[0] = startX;
        extent[1] = startY;
        extent[2] = startX;
        extent[3] = startY;
        LinkedList<int[]> queue = new LinkedList<int[]>();
        queue.add(new int[]{startX, startY});
        int width = img.getWidth();
        int height = img.getHeight();
        while (!queue.isEmpty()) {
            LinkedList<int[]> queueNew = new LinkedList<int[]>();
            for (int[] pos : queue) {
                int west;
                if (img.getRGB(pos[0], pos[1]) != targetColor) continue;
                int east = west = pos[0];
                while (west > 0 && img.getRGB(west - 1, pos[1]) == targetColor) {
                    --west;
                }
                while (east < width - 1 && img.getRGB(east + 1, pos[1]) == targetColor) {
                    ++east;
                }
                for (int i = west; i <= east; ++i) {
                    img.setRGB(i, pos[1], replacementColor);
                    if (pos[1] > 0 && img.getRGB(i, pos[1] - 1) == targetColor) {
                        queueNew.add(new int[]{i, pos[1] - 1});
                    }
                    if (pos[1] >= height - 1 || img.getRGB(i, pos[1] + 1) != targetColor) continue;
                    queueNew.add(new int[]{i, pos[1] + 1});
                }
                if (extent[0] > west) {
                    extent[0] = west;
                }
                if (extent[2] < east) {
                    extent[2] = east;
                }
                if (extent[1] > pos[1]) {
                    extent[1] = pos[1];
                }
                if (extent[3] >= pos[1]) continue;
                extent[3] = pos[1];
            }
            queue = queueNew;
        }
        return true;
    }

    public static BufferedImageContainer read(File file) {
        try {
            BufferedImageContainer result = new BufferedImageContainer();
            ImageInputStream iis = ImageIO.createImageInputStream(new FileInputStream(file.getAbsoluteFile()));
            Iterator<ImageReader> it = ImageIO.getImageReaders(iis);
            if (!it.hasNext()) {
                System.err.println("No reader for this format: " + file);
                return null;
            }
            ImageReader reader = it.next();
            reader.setInput(iis);
            IIOMetadata meta = reader.getImageMetadata(0);
            DOMToProperties convert = new DOMToProperties();
            convert.setStoreAttributes(true);
            convert.setSkipRoot(true);
            String[] formats = meta.getMetadataFormatNames();
            Properties props = new Properties();
            for (String format : formats) {
                convert.setInput(meta.getAsTree(format));
                if (convert.convert() != null) continue;
                props.add((Properties)convert.getOutput());
            }
            convert.cleanUp();
            result.setReport(Report.parseProperties(props));
            BufferedImage image = reader.read(0);
            result.setImage(image);
            return result;
        }
        catch (Exception e) {
            System.err.println("Failed to read image: " + file);
            e.printStackTrace();
            return null;
        }
    }
}

