/*
 * Decompiled with CFR 0.152.
 */
package adams.data.outlier;

import adams.core.io.PlaceholderFile;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.data.container.DataContainer;
import adams.data.outlier.AbstractOutlierDetector;

public abstract class AbstractScriptedOutlierDetector
extends AbstractOutlierDetector
implements FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -8187233244973711251L;
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    public void reset() {
        super.reset();
        this.m_ScriptObject = null;
    }

    @Override
    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    @Override
    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    @Override
    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    @Override
    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = this.loadScriptObject();
        if (result == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    protected void checkData(DataContainer data) {
        super.checkData(data);
        String msg = this.initScriptObject();
        if (msg != null) {
            throw new IllegalStateException(msg);
        }
    }

    @Override
    public void destroy() {
        super.destroy();
        this.m_ScriptObject = null;
    }
}

