/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.core.Properties;
import adams.core.logging.LoggingObject;
import adams.env.Environment;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public class Drivers
extends LoggingObject {
    private static final long serialVersionUID = -2996917112110549746L;
    public static final String FILENAME = "Drivers.props";
    public static final String KEY_DRIVERS = "Drivers";
    protected static Drivers m_Singleton;
    protected Properties m_Properties = Environment.getInstance().read("drivers");
    protected transient List m_Drivers;

    private Drivers() {
        this.getDrivers();
    }

    public List getDrivers() {
        if (this.m_Drivers == null) {
            String[] list;
            this.m_Drivers = new ArrayList();
            for (String driver : list = this.m_Properties.getProperty(KEY_DRIVERS, "").replace(" ", "").split(",")) {
                try {
                    this.m_Drivers.add(Class.forName(driver).newInstance());
                }
                catch (Exception e) {
                    this.getLogger().log(Level.SEVERE, "Failed to load driver '" + driver + "': ", e);
                }
            }
        }
        return this.m_Drivers;
    }

    public static synchronized Drivers getSingleton() {
        if (m_Singleton == null) {
            m_Singleton = new Drivers();
        }
        return m_Singleton;
    }
}

