/*
 * Decompiled with CFR 0.152.
 */
package adams.db;

import adams.db.AbstractTableCleanUp;
import adams.db.SQL;
import adams.db.SQLStatement;
import java.sql.Statement;
import java.util.logging.Level;

public class SQLTableCleanUp
extends AbstractTableCleanUp {
    private static final long serialVersionUID = 2617358965818813327L;
    protected SQLStatement m_Statement;

    @Override
    public String globalInfo() {
        return "Executes an SQL statement to clean up the table.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("statement", "statement", new SQLStatement());
    }

    public void setStatement(SQLStatement value) {
        this.m_Statement = value;
    }

    public SQLStatement getStatement() {
        return this.m_Statement;
    }

    public String statementTipText() {
        return "The SQL statement to use for cleaning up the table.";
    }

    @Override
    protected String check() {
        String result = super.check();
        if (result == null && this.m_Statement.isEmpty()) {
            result = "SQL statement is empty!";
        }
        return result;
    }

    @Override
    protected String doCleanUpTable() {
        String result = null;
        try {
            Statement stmt = this.m_Connection.getConnection(false).createStatement();
            stmt.executeUpdate(this.m_Statement.getValue());
            SQL.close(stmt);
        }
        catch (Exception e) {
            String msg = "Failed to execute '" + this.m_Statement + "': ";
            result = msg + e;
            this.getLogger().log(Level.SEVERE, msg, e);
        }
        return result;
    }
}

