/*
 * Decompiled with CFR 0.152.
 */
package adams.doc.javadoc;

import adams.core.ClassLister;
import adams.core.logging.LoggingObject;
import adams.core.net.HtmlUtils;
import adams.core.option.AbstractOptionConsumer;
import adams.core.option.ArrayConsumer;
import adams.core.option.OptionHandler;
import adams.core.option.OptionManager;
import adams.core.option.OptionUtils;
import adams.doc.javadoc.AllJavadoc;
import adams.env.Environment;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;
import java.util.logging.Level;

public abstract class Javadoc
extends LoggingObject
implements OptionHandler {
    private static final long serialVersionUID = 4088919470813459046L;
    protected String[] m_StartTag;
    protected String[] m_EndTag;
    protected boolean[] m_IsBlock;
    protected String m_Classname;
    protected boolean m_UseStars;
    protected String m_Dir;
    protected boolean m_Silent;
    protected String m_Environment;
    protected OptionManager m_OptionManager;

    public Javadoc() {
        this.initialize();
        this.defineOptions();
        this.getOptionManager().setDefaults();
    }

    protected void initialize() {
        this.m_StartTag = null;
        this.m_EndTag = null;
        this.m_IsBlock = null;
        this.m_Classname = Javadoc.class.getName();
        this.m_UseStars = true;
        this.m_Dir = "";
        this.m_Silent = false;
    }

    protected OptionManager newOptionManager() {
        return new OptionManager(this);
    }

    @Override
    public void defineOptions() {
        this.m_OptionManager = this.newOptionManager();
        this.m_OptionManager.add("env", "environment", Environment.class.getName());
        this.m_OptionManager.add("W", "classname", AllJavadoc.class.getName());
        this.m_OptionManager.add("nostars", "useStars", true);
        this.m_OptionManager.add("dir", "dir", ".");
        this.m_OptionManager.add("silent", "silent", false);
    }

    @Override
    public OptionManager getOptionManager() {
        if (this.m_OptionManager == null) {
            this.defineOptions();
        }
        return this.m_OptionManager;
    }

    @Override
    public void cleanUpOptions() {
        if (this.m_OptionManager != null) {
            this.m_OptionManager.cleanUp();
            this.m_OptionManager = null;
        }
    }

    @Override
    public void destroy() {
        this.cleanUpOptions();
    }

    public void setEnvironment(String value) {
        this.m_Environment = value;
    }

    public String getEnvironment() {
        return this.m_Environment;
    }

    public String environmentTipText() {
        return "The class to use for determining the environment.";
    }

    public void setClassname(String value) {
        this.m_Classname = value;
    }

    public String getClassname() {
        return this.m_Classname;
    }

    public String classnameTipText() {
        return "The class to load.";
    }

    public void setUseStars(boolean value) {
        this.m_UseStars = value;
    }

    public boolean getUseStars() {
        return this.m_UseStars;
    }

    public String useStarsTipText() {
        return "Controls the use of '*' in the Javadoc.";
    }

    public void setDir(String value) {
        this.m_Dir = value;
    }

    public String getDir() {
        return this.m_Dir;
    }

    public String dirTipText() {
        return "The directory above the package hierarchy of the class.";
    }

    public void setSilent(boolean value) {
        this.m_Silent = value;
    }

    public boolean getSilent() {
        return this.m_Silent;
    }

    public String silentTipText() {
        return "Suppresses printing in the console.";
    }

    protected void println(Object o) {
        if (!this.getSilent()) {
            this.getLogger().severe(o.toString());
        }
    }

    protected boolean canInstantiateClass() {
        boolean result = true;
        Class<?> cls = null;
        try {
            cls = Class.forName(this.getClassname());
        }
        catch (Exception e) {
            result = false;
            this.println("Cannot instantiate '" + this.getClassname() + "'! Class in CLASSPATH?");
        }
        if (result) {
            try {
                cls.newInstance();
            }
            catch (Exception e) {
                result = false;
                this.println("Cannot instantiate '" + this.getClassname() + "'! Missing default constructor?");
            }
        }
        return result;
    }

    protected Object getInstance() {
        Object result = null;
        try {
            Class<?> cls = Class.forName(this.getClassname());
            result = cls.newInstance();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected String toHTML(String s) {
        String result = HtmlUtils.toHTML(s);
        result = result.replaceAll("\n", "<br/>\n");
        result = result.replaceAll("\t", "&nbsp;&nbsp;&nbsp;");
        result = result.replace("\\u", "\\\\u");
        return result;
    }

    protected String indent(String content, int count, String indentStr) {
        StringTokenizer tok = new StringTokenizer(content, "\n", true);
        String result = "";
        while (tok.hasMoreTokens()) {
            if (result.endsWith("\n") || result.length() == 0) {
                for (int i = 0; i < count; ++i) {
                    result = result + indentStr;
                }
            }
            result = result + tok.nextToken();
        }
        return result;
    }

    protected abstract String generateJavadoc(int var1) throws Exception;

    protected String generateJavadoc() throws Exception {
        String result = "";
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            if (i > 0) {
                result = result + "\n\n";
            }
            result = result + this.generateJavadoc(i).trim();
        }
        return result;
    }

    protected String getIndentionString(String str) {
        String result = str.replaceAll(" ", "").length() == 0 ? " " : (str.replaceAll("\t", "").length() == 0 ? "\t" : str);
        return result;
    }

    protected int getIndentionLength(String str) {
        int result = str.replaceAll(" ", "").length() == 0 ? str.length() : (str.replaceAll("\t", "").length() == 0 ? str.length() : 1);
        return result;
    }

    protected String updateJavadoc(String content, int index) throws Exception {
        if (content.indexOf(this.m_StartTag[index]) == -1 || content.indexOf(this.m_EndTag[index]) == -1) {
            this.println("No start and/or end tags found: " + this.m_StartTag[index] + "/" + this.m_EndTag[index]);
            return content;
        }
        StringBuilder resultBuf = new StringBuilder();
        while (content.length() > 0) {
            if (content.indexOf(this.m_StartTag[index]) > -1) {
                String part = content.substring(0, content.indexOf(this.m_StartTag[index]));
                if (part.endsWith("\"")) {
                    resultBuf.append(part);
                    resultBuf.append(this.m_StartTag[index]);
                    content = content.substring(part.length() + this.m_StartTag[index].length());
                    continue;
                }
                String tmpStr = part.substring(part.lastIndexOf("\n") + 1);
                part = part.substring(0, part.lastIndexOf("\n") + 1);
                int indentionLen = this.getIndentionLength(tmpStr);
                String indentionStr = this.getIndentionString(tmpStr);
                resultBuf.append(part);
                if (this.m_IsBlock[index]) {
                    resultBuf.append(this.indent(this.m_StartTag[index], indentionLen, indentionStr));
                    resultBuf.append("\n");
                    resultBuf.append(this.indent(this.generateJavadoc(index), indentionLen, indentionStr));
                    resultBuf.append(this.indent(this.m_EndTag[index], indentionLen, indentionStr));
                } else {
                    resultBuf.append(this.indent(this.m_StartTag[index], indentionLen, indentionStr));
                    resultBuf.append(this.indent(this.generateJavadoc(index), 0, ""));
                    resultBuf.append(this.indent(this.m_EndTag[index], 0, ""));
                }
                content = content.substring(content.indexOf(this.m_EndTag[index]));
                content = content.substring(this.m_EndTag[index].length());
                continue;
            }
            resultBuf.append(content);
            content = "";
        }
        return resultBuf.toString().trim();
    }

    protected String updateJavadoc(String content) throws Exception {
        String result = content;
        for (int i = 0; i < this.m_StartTag.length; ++i) {
            result = this.updateJavadoc(result, i);
        }
        return result;
    }

    public String updateJavadoc() throws Exception {
        String result = "";
        File file = new File(this.getDir() + "/" + this.getClassname().replaceAll("\\.", "/") + ".java");
        if (!file.exists()) {
            this.println("File '" + file.getAbsolutePath() + "' doesn't exist!");
            return result;
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder contentBuf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                contentBuf.append(line + "\n");
            }
            reader.close();
            result = this.updateJavadoc(contentBuf.toString());
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to update javadoc", e);
        }
        return result.trim();
    }

    public String generate() throws Exception {
        if (this.getDir().length() == 0) {
            return this.generateJavadoc();
        }
        return this.updateJavadoc();
    }

    public String toString() {
        return OptionUtils.getCommandLine(this);
    }

    public static Javadoc forName(String classname, String[] options) {
        Javadoc result;
        try {
            result = (Javadoc)OptionUtils.forName(Javadoc.class, classname, options);
        }
        catch (Exception e) {
            e.printStackTrace();
            result = null;
        }
        return result;
    }

    public static Javadoc forCommandLine(String cmdline) {
        return (Javadoc)AbstractOptionConsumer.fromString(ArrayConsumer.class, cmdline);
    }

    public static void runJavadoc(Class javadoc, String[] options) {
        String env = OptionUtils.getOption(options, "-env");
        if (env == null || env.length() == 0) {
            env = Environment.class.getName();
        }
        try {
            Environment.setEnvironmentClass(Class.forName(env));
        }
        catch (Exception e) {
            e.printStackTrace();
            Environment.setEnvironmentClass(Environment.class);
        }
        try {
            Javadoc javadocInst;
            try {
                if (OptionUtils.helpRequested(options)) {
                    System.out.println("Help requested...\n");
                    Javadoc javadocInst2 = Javadoc.forName(javadoc.getName(), new String[0]);
                    System.out.println("\n" + OptionUtils.list(javadocInst2));
                    return;
                }
                javadocInst = Javadoc.forName(javadoc.getName(), options);
                if (javadocInst.getDir().length() == 0) {
                    throw new Exception("No directory provided!");
                }
            }
            catch (Exception ex) {
                String result = "\n" + ex.getMessage() + "\n\n" + OptionUtils.list(Javadoc.forName(javadoc.getName(), new String[0]));
                throw new Exception(result);
            }
            System.out.println(javadocInst.generate());
            System.exit(0);
        }
        catch (Exception ex) {
            System.err.println(ex.getMessage());
        }
    }

    public static String[] getJavadocs() {
        return ClassLister.getSingleton().getClassnames(Javadoc.class);
    }
}

