/*
 * Decompiled with CFR 0.152.
 */
package adams.env;

import adams.env.AbstractEnvironment;
import java.io.Serializable;
import java.util.List;

public abstract class AbstractPropertiesDefinition
implements Serializable {
    private static final long serialVersionUID = -3693649083932752468L;

    public abstract String getKey();

    public abstract String getFile();

    public boolean hasAlternativeExtension() {
        return this.getAlternativeExtension() != null;
    }

    public String getAlternativeExtension() {
        return null;
    }

    public String createPath(String dir) {
        return this.createPath(dir, null);
    }

    public String createPath(String dir, String ext) {
        String result = dir;
        if (!dir.endsWith("/")) {
            result = result + "/";
        }
        result = ext == null ? result + this.getFile() : result + this.getFile().replace(".props", "." + ext);
        return result;
    }

    protected void add(AbstractEnvironment env, String propsdir, String[] overrides) {
        env.add(this.getKey(), this.createPath(propsdir), overrides);
        if (this.hasAlternativeExtension()) {
            env.add(this.getKey(), this.createPath(propsdir, this.getAlternativeExtension()), overrides);
        }
    }

    protected void add(AbstractEnvironment env, String propsdir, String home, String[] overrides) {
        env.add(this.getKey(), this.createPath(propsdir), home, overrides);
        if (this.hasAlternativeExtension()) {
            env.add(this.getKey(), this.createPath(propsdir, this.getAlternativeExtension()), home, overrides);
        }
    }

    protected void add(AbstractEnvironment env, String propsdir, List<String> dirs, String[] overrides) {
        env.add(this.getKey(), this.createPath(propsdir), dirs, overrides);
        if (this.hasAlternativeExtension()) {
            env.add(this.getKey(), this.createPath(propsdir, this.getAlternativeExtension()), dirs, overrides);
        }
    }

    protected void replace(AbstractEnvironment env, String propsdir) {
        env.replace(this.getKey(), this.createPath(propsdir));
    }

    protected void replace(AbstractEnvironment env, String propsdir, List<String> dirs) {
        env.replace(this.getKey(), this.createPath(propsdir), dirs);
    }

    public abstract void update(AbstractEnvironment var1);
}

