/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.condition.test;

import adams.core.io.FlowFile;
import adams.flow.FlowRunner;
import adams.flow.condition.test.FileExists;

public class OptionalFlowExecution
extends FileExists {
    private static final long serialVersionUID = 3297313699016976690L;
    protected FlowFile m_FlowFile;
    protected boolean m_Headless;

    @Override
    public String globalInfo() {
        return "Checks whether a specified file exists. If not, then the specified flow is run. After the flow finishes, the check is performed once again, whether the file exists or not.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("headless", "headless", false);
        this.m_OptionManager.add("flow", "flowFile", new FlowFile("."));
    }

    public void setHeadless(boolean value) {
        this.m_Headless = value;
        this.reset();
    }

    public boolean isHeadless() {
        return this.m_Headless;
    }

    public String headlessTipText() {
        return "If set to true, the actor is run in headless mode without GUI components.";
    }

    public void setFlowFile(FlowFile value) {
        this.m_FlowFile = value;
        this.reset();
    }

    public FlowFile getFlowFile() {
        return this.m_FlowFile;
    }

    public String flowFileTipText() {
        return "The flow to run if the file doesn't exist.";
    }

    @Override
    protected String performTest() {
        String result = null;
        if (!this.m_File.exists()) {
            FlowRunner flow = new FlowRunner();
            flow.setInput(this.m_FlowFile);
            flow.setHeadless(this.isHeadless());
            result = flow.execute();
        }
        if (result == null) {
            result = super.performTest();
        }
        return result;
    }
}

