/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.control;

import adams.core.Utils;
import adams.core.logging.LoggingLevel;
import adams.flow.control.Sequence;
import adams.flow.core.AbstractActor;
import adams.flow.core.ActorHandlerInfo;
import adams.flow.core.Compatibility;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.MutableActorHandler;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.transformer.AbstractDataProcessor;
import java.io.File;

public class FileProcessor
extends AbstractDataProcessor
implements MutableActorHandler,
ControlActor {
    private static final long serialVersionUID = 296261057990241918L;
    protected Sequence m_Actors;
    protected boolean m_UseFiles;
    protected transient AbstractActor m_Input;

    @Override
    public String globalInfo() {
        return "Processes arriving files one by one, placing them in the 'processing'directory while working on them. If successfully processed, they get placed in 'processed', otherwise in 'failed'.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("actor", "actors", new AbstractActor[0]);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_Input = null;
        this.m_Actors = new Sequence();
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_Input = null;
    }

    @Override
    public void setLoggingLevel(LoggingLevel value) {
        super.setLoggingLevel(value);
        this.m_Actors.setLoggingLevel(value);
    }

    protected void updateParent() {
        this.m_Actors.setName(this.getName());
        this.m_Actors.setParent(null);
        this.m_Actors.setParent(this.getParent());
    }

    protected String checkSubActor(int index, AbstractActor actor) {
        if (index == 0 && !actor.getSkip()) {
            if (!(actor instanceof InputConsumer)) {
                return "Actor at position #" + (index + 1) + " does not accept input!";
            }
            Compatibility comp = new Compatibility();
            if (!comp.isCompatible(this.accepts(), ((InputConsumer)((Object)actor)).accepts())) {
                return "Actor at #" + (index + 1) + " must accept: " + Utils.classesToString(this.accepts()) + "!";
            }
        }
        return null;
    }

    protected String checkSubActors(AbstractActor[] actors) {
        int index = -1;
        for (int i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip()) continue;
            index = i;
            break;
        }
        if (index == -1) {
            return null;
        }
        if (!(actors[index] instanceof InputConsumer)) {
            return "Actor at position #" + (index + 1) + " does not accept input!";
        }
        Compatibility comp = new Compatibility();
        if (!comp.isCompatible(this.accepts(), ((InputConsumer)((Object)actors[index])).accepts())) {
            return "Actor at #" + (index + 1) + " must accept: " + Utils.classesToString(this.accepts()) + "!";
        }
        return null;
    }

    public void setActors(AbstractActor[] value) {
        String msg = this.checkSubActors(value);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.setActors(value);
        this.reset();
        this.updateParent();
    }

    public AbstractActor[] getActors() {
        return this.m_Actors.getActors();
    }

    public String actorsTipText() {
        return "The actors to siphon-off the tokens to.";
    }

    @Override
    public ActorHandlerInfo getActorHandlerInfo() {
        return this.m_Actors.getActorHandlerInfo();
    }

    @Override
    public String check() {
        return this.m_Actors.check();
    }

    @Override
    public int size() {
        return this.m_Actors.size();
    }

    @Override
    public AbstractActor get(int index) {
        return this.m_Actors.get(index);
    }

    @Override
    public void set(int index, AbstractActor actor) {
        this.m_Actors.set(index, actor);
    }

    @Override
    public int indexOf(String actor) {
        return this.m_Actors.indexOf(actor);
    }

    @Override
    public AbstractActor firstActive() {
        return this.m_Actors.firstActive();
    }

    @Override
    public AbstractActor lastActive() {
        return this.m_Actors.lastActive();
    }

    @Override
    public Class[] generates() {
        if (this.lastActive() instanceof OutputProducer) {
            return ((OutputProducer)((Object)this.lastActive())).generates();
        }
        return new Class[0];
    }

    @Override
    public void add(AbstractActor actor) {
        this.add(this.size(), actor);
    }

    @Override
    public void add(int index, AbstractActor actor) {
        String msg = this.checkSubActor(index, actor);
        if (msg != null) {
            throw new IllegalArgumentException(msg);
        }
        this.m_Actors.add(index, actor);
        this.reset();
        this.updateParent();
    }

    @Override
    public AbstractActor remove(int index) {
        AbstractActor result = this.m_Actors.remove(index);
        this.reset();
        return result;
    }

    @Override
    public void removeAll() {
        this.m_Actors.removeAll();
        this.reset();
    }

    protected String setUpSubActors() {
        String result = null;
        if (result == null && !this.getSkip()) {
            this.updateParent();
            if (result == null) {
                result = this.m_Actors.setUp();
            }
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null && (result = this.setUpSubActors()) == null) {
            this.m_Input = this.firstActive();
            if (this.m_Input == null) {
                result = "No active sub-actor available!";
            }
            if (result == null) {
                Compatibility comp = new Compatibility();
                this.m_UseFiles = comp.isCompatible(new Class[]{File.class}, this.accepts());
            }
        }
        return result;
    }

    @Override
    protected boolean processData(File file) {
        boolean result;
        try {
            if (this.m_UseFiles) {
                ((InputConsumer)((Object)this.m_Input)).input(new Token(file.getAbsoluteFile()));
            } else {
                ((InputConsumer)((Object)this.m_Input)).input(new Token(file.getAbsolutePath()));
            }
            this.m_ProcessError = this.m_Actors.execute();
            boolean bl = result = this.m_ProcessError == null;
            if (result) {
                this.m_OutputToken = new Token(this.m_DestinationFile);
            }
        }
        catch (Exception e) {
            result = false;
            this.m_ProcessError = this.handleException("Failed to process: " + file, e);
        }
        return result;
    }

    @Override
    public void stopExecution() {
        super.stopExecution();
        this.m_Actors.stopExecution();
    }

    @Override
    public void wrapUp() {
        this.m_Actors.wrapUp();
        super.wrapUp();
    }

    @Override
    public void cleanUp() {
        this.m_Actors.cleanUp();
        super.cleanUp();
    }
}

