/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.core.scripting.FileBasedScriptingWithOptions;
import adams.flow.core.AbstractActor;
import java.util.Hashtable;

public abstract class AbstractScriptedActor
extends AbstractActor
implements FileBasedScriptingWithOptions {
    private static final long serialVersionUID = -8187233244973711251L;
    public static final String BACKUP_SCRIPTOBJECT = "script object";
    protected PlaceholderFile m_ScriptFile;
    protected String m_ScriptOptions;
    protected transient Object m_ScriptObject;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("script", "scriptFile", new PlaceholderFile("."));
        this.m_OptionManager.add("options", "scriptOptions", "");
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "scriptFile", new String(this.m_ScriptFile + " " + this.m_ScriptOptions).trim());
    }

    @Override
    public void setScriptFile(PlaceholderFile value) {
        this.m_ScriptFile = value;
        this.reset();
    }

    @Override
    public PlaceholderFile getScriptFile() {
        return this.m_ScriptFile;
    }

    @Override
    public String scriptFileTipText() {
        return "The script file to load and execute.";
    }

    @Override
    public void setScriptOptions(String value) {
        this.m_ScriptOptions = value;
        this.reset();
    }

    @Override
    public String getScriptOptions() {
        return this.m_ScriptOptions;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script.";
    }

    @Override
    protected void pruneBackup() {
        super.pruneBackup();
        this.pruneBackup(BACKUP_SCRIPTOBJECT);
    }

    @Override
    protected Hashtable<String, Object> backupState() {
        Hashtable<String, Object> result = super.backupState();
        if (this.m_ScriptObject != null) {
            result.put(BACKUP_SCRIPTOBJECT, this.m_ScriptObject);
        }
        return result;
    }

    @Override
    protected void restoreState(Hashtable<String, Object> state) {
        if (state.containsKey(BACKUP_SCRIPTOBJECT)) {
            this.m_ScriptObject = state.get(BACKUP_SCRIPTOBJECT);
            state.remove(BACKUP_SCRIPTOBJECT);
        }
        super.restoreState(state);
    }

    protected abstract String loadScriptObject();

    protected abstract String checkScriptObject();

    protected String initScriptObject() {
        String result = null;
        if (this.m_ScriptObject == null && (result = this.loadScriptObject()) == null) {
            result = this.checkScriptObject();
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            result = this.initScriptObject();
        }
        return result;
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        this.m_ScriptObject = null;
    }
}

