/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.QuickInfoHelper;
import adams.core.option.OptionHandler;
import adams.core.scripting.AbstractScriptingHandler;
import adams.core.scripting.Dummy;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractScriptedActor;
import adams.flow.core.ActorUtils;
import adams.flow.core.AdditionalOptionsHandlerUtils;

public abstract class AbstractScriptingHandlerActor
extends AbstractScriptedActor {
    private static final long serialVersionUID = -5904986133981940404L;
    protected transient AbstractActor m_ActorObject;
    protected AbstractScriptingHandler m_Handler;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("handler", "handler", new Dummy());
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "handler", this.m_Handler.getClass(), ", handler: ");
        return result;
    }

    @Override
    public String scriptOptionsTipText() {
        return "The options for the script; must consist of 'key=value' pairs separated by blanks; the value of 'key' can be accessed via the 'getAdditionalOptions().getXYZ(\"key\")' method in the script actor.";
    }

    public void setHandler(AbstractScriptingHandler value) {
        this.m_Handler = value;
        this.reset();
    }

    public AbstractScriptingHandler getHandler() {
        return this.m_Handler;
    }

    public String handlerTipText() {
        return "The handler to use for scripting.";
    }

    @Override
    protected String loadScriptObject() {
        Object[] result = this.m_Handler.loadScriptObject(AbstractActor.class, this.m_ScriptFile, this.m_ScriptOptions, this.getVariables());
        this.m_ScriptObject = result[1];
        return (String)result[0];
    }

    @Override
    protected String checkScriptObject() {
        String result = null;
        AbstractActor script = (AbstractActor)this.m_ScriptObject;
        if (ActorUtils.isStandalone(this) && !ActorUtils.isStandalone(script)) {
            result = "Script object is not a singleton!";
        } else if (ActorUtils.isSource(this) && !ActorUtils.isSource(script)) {
            result = "Script object is not a source!";
        } else if (ActorUtils.isTransformer(this) && !ActorUtils.isTransformer(script)) {
            result = "Script object is not a transformer!";
        } else if (ActorUtils.isSink(this) && !ActorUtils.isSink(script)) {
            result = "Script object is not a sink!";
        }
        return result;
    }

    @Override
    public String setUp() {
        String result = super.setUp();
        if (result == null) {
            this.m_ActorObject = (AbstractActor)this.m_ScriptObject;
            result = this.m_ActorObject.setUp();
        }
        return result;
    }

    protected String updateScriptOptions() {
        if (this.getScriptOptions().length() == 0) {
            return null;
        }
        try {
            AdditionalOptionsHandlerUtils.setOptions(this.m_ActorObject, this.getScriptOptions(), this.getVariables());
            return null;
        }
        catch (Exception e) {
            return this.handleException("Failed to update options", e);
        }
    }

    @Override
    public void wrapUp() {
        super.wrapUp();
        if (this.m_ActorObject != null) {
            this.m_ActorObject.destroy();
        }
        this.m_ActorObject = null;
    }
}

