/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.core;

import adams.core.ClassLister;
import adams.core.ClassLocator;
import adams.core.Utils;
import adams.core.VariablesHandler;
import adams.core.logging.LoggingHelper;
import adams.core.option.AbstractArgumentOption;
import adams.core.option.AbstractOption;
import adams.core.option.OptionHandler;
import adams.data.io.input.DefaultFlowReader;
import adams.data.io.output.DefaultFlowWriter;
import adams.db.AbstractDatabaseConnection;
import adams.env.Environment;
import adams.flow.control.Sequence;
import adams.flow.control.SubProcess;
import adams.flow.core.AbstractActor;
import adams.flow.core.AbstractExternalActor;
import adams.flow.core.Actor;
import adams.flow.core.ActorHandler;
import adams.flow.core.ActorPath;
import adams.flow.core.ControlActor;
import adams.flow.core.InputConsumer;
import adams.flow.core.InstantiatableActor;
import adams.flow.core.OutputProducer;
import adams.flow.core.Token;
import adams.flow.processor.AbstractActorProcessor;
import adams.flow.processor.CheckProcessor;
import adams.flow.processor.CleanUpProcessor;
import adams.flow.processor.MultiProcessor;
import adams.flow.processor.RemoveDisabledActors;
import adams.flow.sink.InstantiatableSink;
import adams.flow.source.InstantiatableSource;
import adams.flow.source.SequenceSource;
import adams.flow.standalone.InstantiatableStandalone;
import adams.flow.standalone.Standalones;
import adams.flow.transformer.GlobalTransformer;
import adams.flow.transformer.InstantiatableTransformer;
import adams.gui.application.AbstractApplicationFrame;
import adams.gui.core.GUIHelper;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.PropertyDescriptor;
import java.io.File;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ActorUtils {
    public static final String FLOW_FILENAME_LONG = "flow_filename_long";
    public static final String FLOW_FILENAME_SHORT = "flow_filename_short";
    public static final String FLOW_DIR = "flow_dir";
    private static final Logger LOGGER = LoggingHelper.getConsoleLogger(ActorUtils.class);

    protected static void enumerate(AbstractActor actor, List<AbstractActor> children, HashSet<Class> filter) {
        if (actor instanceof ActorHandler) {
            ActorHandler handler = (ActorHandler)((Object)actor);
            for (int i = 0; i < handler.size(); ++i) {
                boolean add = true;
                if (filter != null && !filter.contains(handler.get(i).getClass())) {
                    add = false;
                }
                if (add) {
                    children.add(handler.get(i));
                }
                ActorUtils.enumerate(handler.get(i), children, filter);
            }
        }
    }

    public static List<AbstractActor> enumerate(AbstractActor actor) {
        return ActorUtils.enumerate(actor, null);
    }

    public static List<AbstractActor> enumerate(AbstractActor actor, Class[] filter) {
        ArrayList<AbstractActor> result = new ArrayList<AbstractActor>();
        HashSet<Class> filterSet = null;
        if (filter != null) {
            filterSet = new HashSet<Class>(Arrays.asList(filter));
        }
        ActorUtils.enumerate(actor, result, filterSet);
        return result;
    }

    public static int replace(OptionHandler handler, Comparable find, Comparable replace, boolean recursive) {
        return ActorUtils.replace(handler, find, replace, recursive, new HashSet<Class>());
    }

    public static int replace(OptionHandler handler, Comparable find, Comparable replace, boolean recursive, HashSet<Class> excluded) {
        int result = 0;
        List<AbstractOption> options = handler.getOptionManager().getOptionsList();
        for (int i = 0; i < options.size(); ++i) {
            int n;
            Object value;
            PropertyDescriptor desc;
            AbstractArgumentOption argoption;
            boolean updated = false;
            if (!(options.get(i) instanceof AbstractArgumentOption) || excluded.contains((argoption = (AbstractArgumentOption)options.get(i)).getBaseClass())) continue;
            if (!argoption.getBaseClass().equals(find.getClass())) {
                if (!recursive || !ClassLocator.hasInterface(OptionHandler.class, argoption.getBaseClass())) continue;
                desc = options.get(i).getDescriptor();
                try {
                    value = desc.getReadMethod().invoke((Object)handler, new Object[0]);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    value = null;
                }
                if (value == null) continue;
                if (argoption.isMultiple()) {
                    for (n = 0; n < Array.getLength(value); ++n) {
                        result += ActorUtils.replace((OptionHandler)Array.get(value, n), find, replace, recursive);
                    }
                    continue;
                }
                result += ActorUtils.replace((OptionHandler)value, find, replace, recursive);
                continue;
            }
            desc = options.get(i).getDescriptor();
            try {
                value = desc.getReadMethod().invoke((Object)handler, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                value = null;
            }
            if (value == null) continue;
            if (argoption.isMultiple()) {
                for (n = 0; n < Array.getLength(value); ++n) {
                    if (!Array.get(value, n).equals(find)) continue;
                    Array.set(value, n, Utils.deepCopy(replace));
                    updated = true;
                    ++result;
                }
            } else if (value.equals(find)) {
                value = Utils.deepCopy(replace);
                updated = true;
                ++result;
            }
            if (!updated) continue;
            try {
                desc.getWriteMethod().invoke((Object)handler, value);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public static boolean uniqueName(AbstractActor actor, ActorHandler handler, int index) {
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < handler.size(); ++i) {
            if (i == index) continue;
            names.add(handler.get(i).getName());
        }
        return ActorUtils.uniqueName(actor, names);
    }

    public static boolean uniqueName(AbstractActor actor, HashSet<String> names) {
        boolean result;
        String name;
        String baseName = actor.getName();
        int i = 0;
        do {
            name = i == 0 ? baseName : baseName + "-" + i;
            ++i;
        } while (names.contains(name));
        boolean bl = result = !name.equals(actor.getName());
        if (result) {
            actor.setName(name);
        }
        return result;
    }

    public static boolean uniqueNames(AbstractActor[] actors) {
        boolean result = false;
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < actors.length; ++i) {
            if (i > 0) {
                result = ActorUtils.uniqueName(actors[i], names) || result;
            }
            names.add(actors[i].getName());
        }
        return result;
    }

    public static List<ActorHandler> findActorHandlers(AbstractActor actor) {
        return ActorUtils.findActorHandlers(actor, false);
    }

    public static List<ActorHandler> findActorHandlers(AbstractActor actor, boolean mustAllowStandalones) {
        return ActorUtils.findActorHandlers(actor, mustAllowStandalones, false);
    }

    public static List<ActorHandler> findActorHandlers(AbstractActor actor, boolean mustAllowStandalones, boolean includeSameLevel) {
        ArrayList<ActorHandler> result = new ArrayList<ActorHandler>();
        AbstractActor root = actor.getRoot();
        AbstractActor child = actor;
        AbstractActor parent = actor.getParent();
        while (parent != null) {
            if (parent instanceof ActorHandler) {
                ActorHandler handler = (ActorHandler)((Object)parent);
                if (includeSameLevel) {
                    int index = handler.indexOf(child.getName());
                    for (int i = index - 1; i >= 0; --i) {
                        ActorHandler subhandler = null;
                        if (handler.get(i) instanceof AbstractExternalActor) {
                            AbstractExternalActor extActor = (AbstractExternalActor)handler.get(i);
                            if (extActor.getExternalActor() instanceof ActorHandler) {
                                subhandler = (ActorHandler)((Object)extActor.getExternalActor());
                            }
                        } else if (handler.get(i) instanceof ActorHandler) {
                            subhandler = (ActorHandler)((Object)handler.get(i));
                        }
                        if (subhandler == null) continue;
                        if (mustAllowStandalones) {
                            if (!subhandler.getActorHandlerInfo().canContainStandalones()) continue;
                            result.add(subhandler);
                            continue;
                        }
                        result.add(subhandler);
                    }
                }
                if (mustAllowStandalones) {
                    if (handler.getActorHandlerInfo().canContainStandalones()) {
                        result.add(handler);
                    }
                } else {
                    result.add(handler);
                }
            }
            if (parent == root) {
                parent = null;
                continue;
            }
            child = parent;
            parent = parent.getParent();
        }
        if (LOGGER.getLevel() != Level.OFF) {
            ArrayList<String> list = new ArrayList<String>();
            for (ActorHandler h : result) {
                list.add(h.getClass().getName() + "/" + ((AbstractActor)((Object)h)).getFullName());
            }
            LOGGER.fine("Actor handlers: " + list + "\n" + Utils.getStackTrace(20));
        }
        return result;
    }

    public static boolean isStandalone(AbstractActor actor) {
        return !(actor instanceof InputConsumer) && !(actor instanceof OutputProducer);
    }

    public static boolean isSource(AbstractActor actor) {
        return !(actor instanceof InputConsumer) && actor instanceof OutputProducer;
    }

    public static boolean isSink(AbstractActor actor) {
        return actor instanceof InputConsumer && !(actor instanceof OutputProducer);
    }

    public static boolean isTransformer(AbstractActor actor) {
        return actor instanceof InputConsumer && actor instanceof OutputProducer;
    }

    public static boolean isControlActor(AbstractActor actor) {
        return actor instanceof ControlActor;
    }

    public static boolean isActorHandler(AbstractActor actor) {
        return actor instanceof ActorHandler;
    }

    public static boolean write(String filename, AbstractActor actor) {
        DefaultFlowWriter writer = new DefaultFlowWriter();
        boolean result = writer.write((Actor)actor, filename);
        return result;
    }

    public static AbstractActor read(String filename) {
        return ActorUtils.read(filename, null);
    }

    public static AbstractActor read(String filename, List<String> errors) {
        return ActorUtils.read(filename, errors, null);
    }

    public static AbstractActor read(String filename, List<String> errors, List<String> warnings) {
        DefaultFlowReader reader = new DefaultFlowReader();
        AbstractActor result = (AbstractActor)reader.read(filename);
        if (errors != null) {
            errors.addAll(reader.getErrors());
        }
        if (warnings != null) {
            warnings.addAll(reader.getWarnings());
        }
        return result;
    }

    public static Hashtable<String, Integer> findGlobalTransformers(AbstractActor actor) {
        List<AbstractActor> actors = ActorUtils.enumerate(actor);
        Hashtable<String, Integer> count = new Hashtable<String, Integer>();
        for (AbstractActor current : actors) {
            if (current.getSkip() || !(current instanceof GlobalTransformer)) continue;
            String name = ((GlobalTransformer)current).getGlobalName().toString();
            if (!count.containsKey(name)) {
                count.put(name, 1);
                continue;
            }
            count.put(name, count.get(name) + 1);
        }
        return count;
    }

    protected static AbstractActor findClosestType(ActorHandler handler, Class type) {
        AbstractActor result = null;
        for (int i = 0; i < handler.size(); ++i) {
            AbstractExternalActor external;
            if (type.isInstance(handler.get(i)) && !handler.get(i).getSkip()) {
                result = handler.get(i);
                break;
            }
            if (handler.get(i) instanceof AbstractExternalActor && (external = (AbstractExternalActor)handler.get(i)).getExternalActor() instanceof ActorHandler && (result = ActorUtils.findClosestType((ActorHandler)((Object)external.getExternalActor()), type)) != null) break;
        }
        return result;
    }

    public static AbstractActor findClosestType(AbstractActor actor, Class type) {
        return ActorUtils.findClosestType(actor, type, false);
    }

    public static AbstractActor findClosestType(AbstractActor actor, Class type, boolean includeSameLevel) {
        AbstractActor result = null;
        List<ActorHandler> handlers = ActorUtils.findActorHandlers(actor, true, includeSameLevel);
        for (int i = 0; i < handlers.size() && (result = ActorUtils.findClosestType(handlers.get(i), type)) == null; ++i) {
        }
        return result;
    }

    public static Point determineLocation(Window window, int x, int y) {
        int diffHeight;
        Point result = new Point();
        Dimension size = window.getSize();
        if (size.getWidth() == 0.0 || size.getHeight() == 0.0) {
            size = window.getPreferredSize();
        }
        Rectangle bounds = GUIHelper.getScreenBounds(window);
        int actX = x == -1 ? 0 : (x == -2 ? (int)(((double)bounds.width - size.getWidth()) / 2.0) : (x == -3 ? (int)((double)bounds.width - size.getWidth()) : x));
        AbstractApplicationFrame main = Environment.getInstance().getApplicationFrame();
        int n = diffHeight = main != null ? main.getSize().height : 0;
        int actY = y == -1 ? diffHeight : (y == -2 ? (int)(((double)bounds.height - size.getHeight() - (double)diffHeight) / 2.0) : (y == -3 ? (int)((double)bounds.height - size.getHeight()) : y));
        result.setLocation(actX, actY);
        return result;
    }

    public static Dimension determineSize(Window window, int x, int y, int width, int height) {
        Dimension size = window.getSize();
        if (size.getWidth() == 0.0 || size.getHeight() == 0.0) {
            size = window.getPreferredSize();
        }
        Rectangle bounds = GUIHelper.getScreenBounds(window);
        int actWidth = width == 0 ? size.width : (width == -1 ? (x > -1 ? bounds.width - x : bounds.width) : width);
        int actHeight = height == 0 ? size.height : (height == -1 ? (x > -1 ? bounds.height - x : bounds.height) : height);
        Dimension result = new Dimension(actWidth, actHeight);
        return result;
    }

    public static AbstractDatabaseConnection getDatabaseConnection(AbstractActor actor, Class cls, AbstractDatabaseConnection defCon) {
        AbstractDatabaseConnection result;
        adams.flow.standalone.AbstractDatabaseConnection conn = (adams.flow.standalone.AbstractDatabaseConnection)ActorUtils.findClosestType(actor, cls, true);
        if (conn != null) {
            result = conn.getConnection();
            LOGGER.fine("Database connection found: " + result + "\n" + Utils.getStackTrace(20));
        } else {
            result = defCon;
            LOGGER.info("No database connection found, using default: " + defCon + "\n" + Utils.getStackTrace(20));
        }
        if (!result.isConnected() && result.getConnectOnStartUp()) {
            try {
                result.connect();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to enable database connection (" + cls.getName() + ") for actor " + actor.getFullName() + ":", e);
            }
        }
        return result;
    }

    public static AbstractActor removeDisabledActors(AbstractActor actor) {
        RemoveDisabledActors processor = new RemoveDisabledActors();
        processor.process(actor);
        AbstractActor result = processor.getModifiedActor();
        if (result == null) {
            result = actor;
        }
        return result;
    }

    public static AbstractActor createExternalActor(AbstractActor[] actors) {
        int i;
        if (actors.length == 0) {
            throw new IllegalArgumentException("At least one actor must be provided for externalizing!");
        }
        HashSet<String> paths = new HashSet<String>();
        for (AbstractActor actor : actors) {
            ActorPath path = new ActorPath(actor.getFullName());
            paths.add(path.getParentPath().toString());
            if (paths.size() <= 1) continue;
            throw new IllegalArgumentException("Actor is not on the same level in the same sub-flow!\n" + actor.getFullName());
        }
        int first = -1;
        for (i = 0; i < actors.length; ++i) {
            if (actors[i].getSkip()) continue;
            first = i;
            break;
        }
        if (first == -1) {
            throw new IllegalArgumentException("At least one actor must be enabled!");
        }
        int last = -1;
        for (i = actors.length - 1; i >= 0; --i) {
            if (actors[i].getSkip()) continue;
            last = i;
            break;
        }
        if (ActorUtils.isStandalone(actors[first]) && ActorUtils.isStandalone(actors[last])) {
            Standalones handler = new Standalones();
            handler.setActors(actors);
            return ActorUtils.createExternalActor(handler);
        }
        if (ActorUtils.isTransformer(actors[first]) && ActorUtils.isTransformer(actors[last])) {
            SubProcess handler = new SubProcess();
            handler.setActors(actors);
            return ActorUtils.createExternalActor(handler);
        }
        if (ActorUtils.isSource(actors[first]) && actors[last] instanceof OutputProducer) {
            SequenceSource handler = new SequenceSource();
            handler.setActors(actors);
            return ActorUtils.createExternalActor(handler);
        }
        if (actors[first] instanceof InputConsumer && ActorUtils.isSink(actors[last])) {
            Sequence handler = new Sequence();
            handler.setActors(actors);
            return ActorUtils.createExternalActor(handler);
        }
        throw new IllegalArgumentException("Failed to find suitable actor handler to enclose all actors!");
    }

    public static AbstractActor createExternalActor(AbstractActor actor) {
        AbstractActor result = actor;
        if (!(actor instanceof InstantiatableActor)) {
            if (ActorUtils.isStandalone(actor)) {
                result = new InstantiatableStandalone();
                ((InstantiatableStandalone)result).set(0, actor);
            } else if (ActorUtils.isSource(actor)) {
                result = new InstantiatableSource();
                ((InstantiatableSource)result).set(0, actor);
            } else if (ActorUtils.isTransformer(actor)) {
                result = new InstantiatableTransformer();
                ((InstantiatableTransformer)result).set(0, actor);
            } else if (ActorUtils.isSink(actor)) {
                result = new InstantiatableSink();
                ((InstantiatableSink)result).set(0, actor);
            }
        }
        return result;
    }

    public static AbstractActor locate(ActorPath path, AbstractActor parent) {
        AbstractActor child;
        AbstractActor result = null;
        if (!(parent instanceof ActorHandler)) {
            return result;
        }
        ActorHandler parentHandler = (ActorHandler)((Object)parent);
        int index = -1;
        for (int i = 0; i < parentHandler.size(); ++i) {
            child = parentHandler.get(i);
            if (!child.getName().equals(path.getFirstPathComponent())) continue;
            index = i;
            break;
        }
        if (index != -1) {
            child = parentHandler.get(index);
            result = path.getPathCount() == 1 ? child : ActorUtils.locate(path.getChildPath(), child);
        } else {
            LOGGER.warning("Malformed path? " + path);
        }
        return result;
    }

    public static AbstractActor locate(String path, AbstractActor root) {
        return ActorUtils.locate(new ActorPath(path), root);
    }

    public static String checkForSource(AbstractActor actor) {
        return ActorUtils.checkForSource(new AbstractActor[]{actor});
    }

    public static String checkForSource(AbstractActor[] actors) {
        String result = null;
        for (int i = 0; i < actors.length; ++i) {
            AbstractActor actor = actors[i];
            if (actor.getSkip() || ActorUtils.isStandalone(actor)) continue;
            if (ActorUtils.isSource(actor)) break;
            result = "First active, non-standalone actor must be a source, but '" + actor.getName() + "' is not!";
            break;
        }
        return result;
    }

    public static AbstractActor cleanUpFlow(AbstractActor actor) {
        AbstractActor result = null;
        MultiProcessor processor = new MultiProcessor();
        String[] names = ClassLister.getSingleton().getClassnames(CleanUpProcessor.class);
        AbstractActorProcessor[] procs = new AbstractActorProcessor[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                procs[i] = (AbstractActorProcessor)Class.forName(names[i]).newInstance();
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to instantiate cleanup processor: " + names[i], e);
                return null;
            }
        }
        processor.setSubProcessors(procs);
        processor.process(actor);
        if (processor.isModified()) {
            result = processor.getModifiedActor();
        }
        return result;
    }

    public static String checkFlow(AbstractActor actor) {
        MultiProcessor processor = new MultiProcessor();
        String[] names = ClassLister.getSingleton().getClassnames(CheckProcessor.class);
        AbstractActorProcessor[] procs = new AbstractActorProcessor[names.length];
        for (int i = 0; i < names.length; ++i) {
            try {
                procs[i] = (AbstractActorProcessor)Class.forName(names[i]).newInstance();
                continue;
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Failed to instantiate check processor: " + names[i], e);
                return null;
            }
        }
        processor.setSubProcessors(procs);
        processor.process(actor);
        String result = processor.getWarnings();
        return result;
    }

    public static boolean updateVariablesWithFlowFilename(VariablesHandler handler, File flow) {
        if (flow == null) {
            return false;
        }
        handler.getLocalVariables().set(FLOW_DIR, flow.getParentFile().getAbsolutePath());
        handler.getLocalVariables().set(FLOW_FILENAME_LONG, flow.getAbsolutePath());
        handler.getLocalVariables().set(FLOW_FILENAME_SHORT, flow.getName());
        return true;
    }

    public static List transform(AbstractActor transformer, Object input) throws Exception {
        ArrayList<Object> result = null;
        if (!ActorUtils.isTransformer(transformer)) {
            throw new IllegalArgumentException("Actor is not a transformer!");
        }
        String msg = transformer.setUp();
        if (msg != null) {
            transformer.cleanUp();
            throw new Exception("Setup of actor failed: " + msg);
        }
        ((InputConsumer)((Object)transformer)).input(new Token(input));
        msg = transformer.execute();
        if (msg != null) {
            transformer.cleanUp();
            throw new Exception("Execution of actor failed: " + msg);
        }
        while (((OutputProducer)((Object)transformer)).hasPendingOutput()) {
            if (result == null) {
                result = new ArrayList<Object>();
            }
            result.add(((OutputProducer)((Object)transformer)).output().getPayload());
        }
        transformer.cleanUp();
        return result;
    }
}

