/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.execution;

import adams.core.option.AbstractOptionHandler;
import adams.flow.core.Actor;
import adams.flow.core.Token;

public abstract class AbstractBreakpoint
extends AbstractOptionHandler {
    private static final long serialVersionUID = 4654096855875796107L;
    protected boolean m_Disabled;
    protected boolean m_OnPreInput;
    protected boolean m_OnPostInput;
    protected boolean m_OnPreExecute;
    protected boolean m_OnPostExecute;
    protected boolean m_OnPreOutput;
    protected boolean m_OnPostOutput;

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("disabled", "disabled", false);
        this.m_OptionManager.add("on-pre-input", "onPreInput", false);
        this.m_OptionManager.add("on-post-input", "onPostInput", false);
        this.m_OptionManager.add("on-pre-execute", "onPreExecute", false);
        this.m_OptionManager.add("on-post-execute", "onPostExecute", false);
        this.m_OptionManager.add("on-pre-output", "onPreOutput", false);
        this.m_OptionManager.add("on-post-output", "onPostOutput", false);
    }

    public void setDisabled(boolean value) {
        this.m_Disabled = value;
        this.reset();
    }

    public boolean getDisabled() {
        return this.m_Disabled;
    }

    public String disabledTipText() {
        return "If set to true, the breakpoint is completely disabled.";
    }

    public void setOnPreInput(boolean value) {
        this.m_OnPreInput = value;
        this.reset();
    }

    public boolean getOnPreInput() {
        return this.m_OnPreInput;
    }

    public String onPreInputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-input (of token) time; token available.";
    }

    public void setOnPostInput(boolean value) {
        this.m_OnPostInput = value;
        this.reset();
    }

    public boolean getOnPostInput() {
        return this.m_OnPostInput;
    }

    public String onPostInputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-input (of token) time.";
    }

    public void setOnPreExecute(boolean value) {
        this.m_OnPreExecute = value;
        this.reset();
    }

    public boolean getOnPreExecute() {
        return this.m_OnPreExecute;
    }

    public String onPreExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-execute time.";
    }

    public void setOnPostExecute(boolean value) {
        this.m_OnPostExecute = value;
        this.reset();
    }

    public boolean getOnPostExecute() {
        return this.m_OnPostExecute;
    }

    public String onPostExecuteTipText() {
        return "If set to true, the breakpoint gets evaluated at post-execute time.";
    }

    public void setOnPreOutput(boolean value) {
        this.m_OnPreOutput = value;
        this.reset();
    }

    public boolean getOnPreOutput() {
        return this.m_OnPreOutput;
    }

    public String onPreOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at pre-output (of token) time; token available.";
    }

    public void setOnPostOutput(boolean value) {
        this.m_OnPostOutput = value;
        this.reset();
    }

    public boolean getOnPostOutput() {
        return this.m_OnPostOutput;
    }

    public String onPostOutputTipText() {
        return "If set to true, the breakpoint gets evaluated at post-output (of token) time.";
    }

    protected abstract boolean evaluatePreInput(Actor var1, Token var2);

    protected abstract boolean evaluatePostInput(Actor var1);

    protected abstract boolean evaluatePreExecute(Actor var1);

    protected abstract boolean evaluatePostExecute(Actor var1);

    protected abstract boolean evaluatePreOutput(Actor var1);

    protected abstract boolean evaluatePostOutput(Actor var1, Token var2);

    public boolean triggersPreInput(Actor actor, Token token) {
        return this.m_OnPreInput && this.evaluatePreInput(actor, token);
    }

    public boolean triggersPostInput(Actor actor) {
        return this.m_OnPostInput && this.evaluatePostInput(actor);
    }

    public boolean triggersPreExecute(Actor actor) {
        return this.m_OnPreExecute && this.evaluatePreExecute(actor);
    }

    public boolean triggersPostExecute(Actor actor) {
        return this.m_OnPostExecute && this.evaluatePostExecute(actor);
    }

    public boolean triggersPreOutput(Actor actor) {
        return this.m_OnPreOutput && this.evaluatePreOutput(actor);
    }

    public boolean triggersPostOutput(Actor actor, Token token) {
        return this.m_OnPostOutput && this.evaluatePostOutput(actor, token);
    }
}

