/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.VariableNameNoUpdate;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.core.InputConsumer;
import adams.flow.core.Token;
import adams.flow.sink.AbstractDisplay;
import adams.flow.sink.ComponentSupplier;
import adams.flow.sink.DisplayPanel;
import adams.flow.sink.DisplayPanelProvider;
import adams.flow.sink.ImageViewer;
import adams.flow.sink.TextSupplier;
import adams.gui.core.BasePanel;
import adams.gui.core.BaseScrollPane;
import adams.gui.core.GUIHelper;
import adams.gui.core.MenuBarProvider;
import adams.gui.print.JComponentWriter;
import adams.gui.print.JComponentWriterFileChooser;
import adams.gui.print.PNGWriter;
import adams.gui.sendto.SendToActionSupporter;
import adams.gui.sendto.SendToActionUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisplayPanelGrid
extends AbstractDisplay
implements MenuBarProvider,
ComponentSupplier,
SendToActionSupporter {
    private static final long serialVersionUID = -8176623753237046447L;
    protected int m_NumColumns;
    protected DisplayPanelProvider m_PanelProvider;
    protected int m_PanelWidth;
    protected int m_PanelHeight;
    protected VariableNameNoUpdate m_TitleVariable;
    protected JMenuBar m_MenuBar;
    protected JMenuItem m_MenuItemFileSaveAs;
    protected JMenuItem m_MenuItemFileClose;
    protected transient JComponentWriterFileChooser m_ComponentFileChooser;
    protected BasePanel m_PanelAll;
    protected List<DisplayPanel> m_DisplayPanels;

    @Override
    public String globalInfo() {
        return "Sink that places a panel in the grid for each each arriving token.\nUses the user-defined panel provider for creating the panels.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("provider", "panelProvider", new ImageViewer());
        this.m_OptionManager.add("num-columns", "numColumns", 2, 1, null);
        this.m_OptionManager.add("panel-width", "panelWidth", 400, 1, null);
        this.m_OptionManager.add("panel-height", "panelHeight", 300, 1, null);
        this.m_OptionManager.add("title-variable", "titleVariable", new VariableNameNoUpdate("titleVariable"));
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_DisplayPanels = new ArrayList<DisplayPanel>();
    }

    @Override
    public String getQuickInfo() {
        String result = super.getQuickInfo();
        result = result + QuickInfoHelper.toString((OptionHandler)this, "numColumns", this.m_NumColumns, ", #cols: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "panelWidth", this.m_PanelWidth, ", pW: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "panelHeight", this.m_PanelHeight, ", pH: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "titleVariable", this.m_TitleVariable, ", title var: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "panelProvider", this.m_PanelProvider.getClass(), ", provider: ");
        return result;
    }

    @Override
    protected int getDefaultWidth() {
        return 800;
    }

    @Override
    protected int getDefaultHeight() {
        return 600;
    }

    public void setPanelProvider(DisplayPanelProvider value) {
        this.m_PanelProvider = value;
        this.reset();
    }

    public DisplayPanelProvider getPanelProvider() {
        return this.m_PanelProvider;
    }

    public String panelProviderTipText() {
        return "The actor for generating the display panels.";
    }

    public void setNumColumns(int value) {
        this.m_NumColumns = value;
        this.reset();
    }

    public int getNumColumns() {
        return this.m_NumColumns;
    }

    public String numColumnsTipText() {
        return "The number of columns to use in the grid.";
    }

    public void setPanelWidth(int value) {
        this.m_PanelWidth = value;
        this.reset();
    }

    public int getPanelWidth() {
        return this.m_PanelWidth;
    }

    public String panelWidthTipText() {
        return "The width of the individual panels.";
    }

    public void setPanelHeight(int value) {
        this.m_PanelHeight = value;
        this.reset();
    }

    public int getPanelHeight() {
        return this.m_PanelHeight;
    }

    public String panelHeightTipText() {
        return "The height of the individual panels.";
    }

    public void setTitleVariable(VariableNameNoUpdate value) {
        this.m_TitleVariable = value;
        this.reset();
    }

    public VariableNameNoUpdate getTitleVariable() {
        return this.m_TitleVariable;
    }

    public String titleVariableTipText() {
        return "The variable to use for the panel title; gets ignored if variable not available and the index of the panel is used instead.";
    }

    @Override
    public Class[] accepts() {
        if (this.m_PanelProvider != null && this.m_PanelProvider instanceof InputConsumer) {
            return ((InputConsumer)((Object)this.m_PanelProvider)).accepts();
        }
        return new Class[]{Object.class};
    }

    @Override
    public void clearPanel() {
        this.m_PanelAll.removeAll();
    }

    @Override
    protected BasePanel newPanel() {
        this.m_PanelAll = new BasePanel(new GridLayout(1, this.m_NumColumns));
        BasePanel result = new BasePanel(new BorderLayout());
        result.add((Component)new BaseScrollPane(this.m_PanelAll), "Center");
        return result;
    }

    @Override
    protected void display(Token token) {
        String title = this.getVariables().has(this.m_TitleVariable.getValue()) ? this.getVariables().get(this.m_TitleVariable.getValue()) : "" + (this.m_DisplayPanels.size() + 1);
        BasePanel panel = new BasePanel(new BorderLayout());
        panel.setPreferredSize(new Dimension(this.m_PanelWidth, this.m_PanelHeight));
        panel.setMinimumSize(new Dimension(this.m_PanelWidth, this.m_PanelHeight));
        panel.setBorder(BorderFactory.createTitledBorder(title));
        DisplayPanel dpanel = this.m_PanelProvider.createDisplayPanel(token);
        this.m_DisplayPanels.add(dpanel);
        int rows = (int)Math.ceil((double)this.m_DisplayPanels.size() / (double)this.m_NumColumns);
        GridLayout layout = (GridLayout)this.m_PanelAll.getLayout();
        if (layout.getRows() < rows) {
            layout.setRows(rows);
        }
        panel.add((Component)((JComponent)((Object)dpanel)), "Center");
        this.m_PanelAll.add(panel);
        this.m_PanelAll.getParent().validate();
        this.m_PanelAll.getParent().repaint();
    }

    protected JMenuBar createMenuBar() {
        JMenuBar result = new JMenuBar();
        JMenu menu = new JMenu("File");
        result.add(menu);
        menu.setMnemonic('F');
        menu.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                DisplayPanelGrid.this.updateMenu();
            }
        });
        JMenuItem menuitem = new JMenuItem("Save as...");
        menu.add(menuitem);
        menuitem.setMnemonic('a');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed S"));
        menuitem.setIcon(GUIHelper.getIcon("save.gif"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanelGrid.this.saveAs();
            }
        });
        this.m_MenuItemFileSaveAs = menuitem;
        menu.addSeparator();
        if (SendToActionUtils.addSendToSubmenu((SendToActionSupporter)this, menu)) {
            menu.addSeparator();
        }
        menuitem = new JMenuItem("Close");
        menu.add(menuitem);
        menuitem.setMnemonic('C');
        menuitem.setAccelerator(GUIHelper.getKeyStroke("ctrl pressed Q"));
        menuitem.setIcon(GUIHelper.getIcon("exit.png"));
        menuitem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DisplayPanelGrid.this.close();
            }
        });
        this.m_MenuItemFileClose = menuitem;
        return result;
    }

    @Override
    public JMenuBar getMenuBar() {
        if (this.m_MenuBar == null) {
            this.m_MenuBar = this.createMenuBar();
            this.updateMenu();
        }
        return this.m_MenuBar;
    }

    protected void updateMenu() {
        if (this.m_MenuBar == null) {
            return;
        }
        this.m_MenuItemFileSaveAs.setEnabled(this.m_PanelProvider instanceof ComponentSupplier || this.m_PanelProvider instanceof TextSupplier);
    }

    protected JComponentWriterFileChooser getComponentFileChooser() {
        if (this.m_ComponentFileChooser == null) {
            this.m_ComponentFileChooser = new JComponentWriterFileChooser();
        }
        return this.m_ComponentFileChooser;
    }

    protected void close() {
        this.m_PanelAll.closeParent();
    }

    protected void saveAs() {
        int retVal = this.getComponentFileChooser().showSaveDialog(this.m_Panel);
        if (retVal != 0) {
            return;
        }
        JComponentWriter writer = this.getComponentFileChooser().getWriter();
        writer.setComponent(this.supplyComponent());
        try {
            writer.toOutput();
        }
        catch (Exception e) {
            this.handleException("Error saving panel to '" + writer.getFile() + "': ", e);
        }
    }

    @Override
    protected void cleanUpGUI() {
        if (this.m_PanelAll != null) {
            this.m_PanelAll.removeAll();
        }
        this.m_DisplayPanels.clear();
        this.m_MenuBar = null;
        this.m_MenuItemFileSaveAs = null;
        this.m_MenuItemFileClose = null;
        super.cleanUpGUI();
    }

    @Override
    public JComponent supplyComponent() {
        return this.m_PanelAll;
    }

    @Override
    public Class[] getSendToClasses() {
        if (this.m_PanelProvider instanceof ComponentSupplier) {
            return new Class[]{PlaceholderFile.class, JComponent.class};
        }
        return new Class[0];
    }

    @Override
    public boolean hasSendToItem(Class[] cls) {
        if (SendToActionUtils.isAvailable(JComponent.class, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            return false;
        }
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            if (this.m_PanelProvider instanceof ComponentSupplier) {
                return this.supplyComponent() != null;
            }
            return false;
        }
        return false;
    }

    @Override
    public Object getSendToItem(Class[] cls) {
        Serializable result = null;
        if (SendToActionUtils.isAvailable(new Class[]{PlaceholderFile.class, String.class}, cls)) {
            JComponent comp;
            if (this.m_PanelProvider instanceof ComponentSupplier && (comp = this.supplyComponent()) != null) {
                result = SendToActionUtils.nextTmpFile("actor-" + this.getName(), "png");
                PNGWriter writer = new PNGWriter();
                writer.setFile((PlaceholderFile)result);
                writer.setComponent(comp);
                try {
                    writer.generateOutput();
                }
                catch (Exception e) {
                    this.handleException("Failed to write image to " + result + ":", e);
                    result = null;
                }
            }
        } else if (SendToActionUtils.isAvailable(JComponent.class, cls) && this.m_PanelProvider instanceof ComponentSupplier) {
            result = this.supplyComponent();
        }
        return result;
    }
}

