/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.io.FileEncodingSupporter;
import adams.flow.core.Unknown;
import adams.flow.sink.AbstractAppendableFileWriter;
import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

public class DumpFile
extends AbstractAppendableFileWriter
implements FileEncodingSupporter {
    private static final long serialVersionUID = -366362262032858011L;
    protected String m_Encoding;

    @Override
    public String globalInfo() {
        return "Actor that just dumps any input token into a separate line of the specified output file.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("encoding", "encoding", "");
    }

    @Override
    public String outputFileTipText() {
        return "The name of the output file.";
    }

    @Override
    public String appendTipText() {
        return "If set to true, file gets only appended.";
    }

    @Override
    public void setEncoding(String value) {
        this.m_Encoding = value;
        this.reset();
    }

    @Override
    public String getEncoding() {
        return this.m_Encoding;
    }

    @Override
    public String encodingTipText() {
        return "The type of encoding to use when writing to the file, use empty string for default.";
    }

    @Override
    public Class[] accepts() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result;
        try {
            BufferedWriter writer = this.m_Encoding.length() > 0 ? new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_OutputFile.getAbsolutePath(), this.m_Append), this.m_Encoding)) : new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.m_OutputFile.getAbsolutePath(), this.m_Append)));
            writer.write("" + this.m_InputToken.getPayload());
            writer.newLine();
            writer.flush();
            writer.close();
            result = null;
        }
        catch (Exception e) {
            result = this.handleException("Failed to write output to " + this.m_OutputFile + ":", e);
        }
        return result;
    }
}

