/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.io.PlaceholderFile;
import adams.core.option.OptionHandler;
import adams.flow.sink.AbstractFileWriter;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class PasteFiles
extends AbstractFileWriter {
    private static final long serialVersionUID = -6717503477934358351L;
    protected String m_Delimiter;

    @Override
    public String globalInfo() {
        return "Generates a single file from combined lines from the input files. Line-by-line the lines get joined (separated by the specified delimiter) and output in the output file.\nThis transformer works similar to the Unix 'paste' command. But instead of providing a list of delimiters, a single one is used.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("delimiter", "delimiter", "\\t");
    }

    @Override
    public String outputFileTipText() {
        return "The output file containing the combined content.";
    }

    public void setDelimiter(String value) {
        this.m_Delimiter = Utils.unbackQuoteChars(value);
        this.reset();
    }

    public String getDelimiter() {
        return Utils.backQuoteChars(this.m_Delimiter);
    }

    public String delimiterTipText() {
        return "The delimiter to use for combining the lines (backquoted, e.g., use '\t' for tab).";
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "delimiter", Utils.backQuoteChars(this.m_Delimiter));
    }

    @Override
    public Class[] accepts() {
        return new Class[]{String[].class, File[].class};
    }

    @Override
    protected String doExecute() {
        int i;
        File[] files;
        String result = null;
        if (this.m_InputToken.getPayload() instanceof String[]) {
            String[] filesStr = (String[])this.m_InputToken.getPayload();
            files = new File[filesStr.length];
            for (i = 0; i < filesStr.length; ++i) {
                files[i] = new PlaceholderFile(filesStr[i]);
            }
        } else {
            files = (File[])this.m_InputToken.getPayload();
        }
        BufferedReader[] reader = new BufferedReader[files.length];
        BufferedWriter writer = null;
        try {
            for (i = 0; i < files.length; ++i) {
                reader[i] = new BufferedReader(new FileReader(files[i].getAbsoluteFile()));
            }
            writer = new BufferedWriter(new FileWriter(this.m_OutputFile.getAbsoluteFile()));
        }
        catch (Exception e) {
            result = this.handleException("Failed to setup readers/writer: ", e);
        }
        String[] read = new String[reader.length];
        if (result == null) {
            try {
                boolean finished;
                block10: do {
                    for (i = 0; i < reader.length; ++i) {
                        read[i] = reader[i].readLine();
                        if (i > 0) {
                            writer.write(this.m_Delimiter);
                        }
                        if (read[i] == null) continue;
                        writer.write(read[i]);
                    }
                    writer.newLine();
                    finished = true;
                    for (i = 0; i < read.length; ++i) {
                        if (read[i] == null) continue;
                        finished = false;
                        continue block10;
                    }
                } while (!finished);
            }
            catch (Exception e) {
                result = this.handleException("Failed to read/write data: ", e);
            }
        }
        for (i = 0; i < reader.length; ++i) {
            if (reader[i] == null) continue;
            try {
                reader[i].close();
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (writer != null) {
            try {
                writer.flush();
                writer.close();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return result;
    }
}

