/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.sink.sequenceplotter;

import adams.flow.sink.sequenceplotter.AbstractErrorPaintlet;
import adams.flow.sink.sequenceplotter.MarkerPaintlet;
import adams.flow.sink.sequenceplotter.NoErrorPaintlet;
import adams.flow.sink.sequenceplotter.SequencePlotContainerManager;
import adams.flow.sink.sequenceplotter.VerticalMarkers;
import adams.gui.core.AntiAliasingSupporter;
import adams.gui.event.DataChangeEvent;
import adams.gui.visualization.core.AbstractColorProvider;
import adams.gui.visualization.sequence.XYSequenceContainer;
import adams.gui.visualization.sequence.XYSequenceContainerManager;
import adams.gui.visualization.sequence.XYSequenceLinePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintlet;
import adams.gui.visualization.sequence.XYSequencePaintletWithCustomerContainerManager;
import adams.gui.visualization.sequence.XYSequencePanel;
import gnu.trove.list.array.TIntArrayList;

public class SequencePlotterPanel
extends XYSequencePanel {
    private static final long serialVersionUID = -325993535017871634L;
    protected MarkerPaintlet m_MarkerPaintlet;
    protected XYSequenceContainerManager m_MarkerContainerManager;
    protected XYSequencePaintlet m_OverlayPaintlet;
    protected XYSequenceContainerManager m_OverlayContainerManager;
    protected AbstractErrorPaintlet m_ErrorPaintlet;

    public SequencePlotterPanel(String title) {
        super(title);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.m_MarkerContainerManager = this.newMarkerContainerManager();
        this.m_OverlayContainerManager = this.newOverlayContainerManager();
    }

    @Override
    protected void initGUI() {
        super.initGUI();
        this.m_MarkerPaintlet = new VerticalMarkers();
        this.m_MarkerPaintlet.setPanel(this);
        this.m_OverlayPaintlet = new XYSequenceLinePaintlet();
        this.m_OverlayPaintlet.setPanel(this);
        ((XYSequencePaintletWithCustomerContainerManager)this.m_OverlayPaintlet).setCustomContainerManager(this.m_OverlayContainerManager);
        this.m_ErrorPaintlet = new NoErrorPaintlet();
        this.m_ErrorPaintlet.setPanel(this);
        this.setAllowResize(true);
    }

    @Override
    protected SequencePlotContainerManager newContainerManager() {
        return new SequencePlotContainerManager(this);
    }

    protected XYSequenceContainerManager newMarkerContainerManager() {
        XYSequenceContainerManager result = new XYSequenceContainerManager(this);
        result.removeDataChangeListener(this);
        return result;
    }

    public XYSequenceContainerManager getMarkerContainerManager() {
        return this.m_MarkerContainerManager;
    }

    protected XYSequenceContainerManager newOverlayContainerManager() {
        XYSequenceContainerManager result = new XYSequenceContainerManager(this);
        result.removeDataChangeListener(this);
        return result;
    }

    public XYSequenceContainerManager getOverlayContainerManager() {
        return this.m_OverlayContainerManager;
    }

    public void setMarkerPaintlet(MarkerPaintlet value) {
        this.m_MarkerPaintlet.setPanel(null);
        this.m_MarkerPaintlet = value;
        this.m_MarkerPaintlet.setPanel(this);
        this.reset();
    }

    public MarkerPaintlet getMarkerPaintlet() {
        return this.m_MarkerPaintlet;
    }

    public void setOverlayPaintlet(XYSequencePaintlet value) {
        this.m_OverlayPaintlet.setPanel(null);
        if (this.m_OverlayPaintlet instanceof XYSequencePaintletWithCustomerContainerManager) {
            ((XYSequencePaintletWithCustomerContainerManager)this.m_OverlayPaintlet).setCustomContainerManager(null);
        }
        this.m_OverlayPaintlet = value;
        this.m_OverlayPaintlet.setPanel(this);
        if (this.m_OverlayPaintlet instanceof XYSequencePaintletWithCustomerContainerManager) {
            ((XYSequencePaintletWithCustomerContainerManager)this.m_OverlayPaintlet).setCustomContainerManager(this.m_OverlayContainerManager);
        }
        this.reset();
    }

    public XYSequencePaintlet getOverlayPaintlet() {
        return this.m_OverlayPaintlet;
    }

    public void setErrorPaintlet(AbstractErrorPaintlet value) {
        this.m_ErrorPaintlet.setPanel(null);
        this.m_ErrorPaintlet = value;
        this.m_ErrorPaintlet.setPanel(this);
        this.reset();
    }

    public AbstractErrorPaintlet getErrorPaintlet() {
        return this.m_ErrorPaintlet;
    }

    public void setColorProvider(AbstractColorProvider value) {
        ((XYSequenceContainerManager)this.getContainerManager()).setColorProvider(value.shallowCopy(true));
        this.getMarkerContainerManager().setColorProvider(this.getColorProvider().shallowCopy(true));
    }

    public AbstractColorProvider getColorProvider() {
        return ((XYSequenceContainerManager)this.getContainerManager()).getColorProvider();
    }

    public void setOverlayColorProvider(AbstractColorProvider value) {
        this.getOverlayContainerManager().setColorProvider(value.shallowCopy(true));
    }

    public AbstractColorProvider getOverlayColorProvider() {
        return this.getOverlayContainerManager().getColorProvider();
    }

    @Override
    public void setAntiAliasingEnabled(boolean value) {
        if (this.m_ErrorPaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)((Object)this.m_ErrorPaintlet)).setAntiAliasingEnabled(value);
        }
        if (this.m_OverlayPaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)((Object)this.m_OverlayPaintlet)).setAntiAliasingEnabled(value);
        }
        if (this.m_MarkerPaintlet instanceof AntiAliasingSupporter) {
            ((AntiAliasingSupporter)((Object)this.m_MarkerPaintlet)).setAntiAliasingEnabled(value);
        }
        super.setAntiAliasingEnabled(value);
    }

    protected int[] toMarkerIndices(int[] seqIndices) {
        TIntArrayList result = new TIntArrayList();
        XYSequenceContainerManager markerManager = this.getMarkerContainerManager();
        XYSequenceContainerManager seqManager = (XYSequenceContainerManager)this.getContainerManager();
        for (int i = 0; i < seqIndices.length; ++i) {
            String id = ((XYSequenceContainer)seqManager.get(seqIndices[i])).getID();
            int index = markerManager.indexOf(id);
            if (index == -1) continue;
            result.add(index);
        }
        return result.toArray();
    }

    protected int[] toOverlayIndices(int[] seqIndices) {
        TIntArrayList result = new TIntArrayList();
        XYSequenceContainerManager overlayManager = this.getMarkerContainerManager();
        XYSequenceContainerManager seqManager = (XYSequenceContainerManager)this.getContainerManager();
        for (int i = 0; i < seqIndices.length; ++i) {
            String id = ((XYSequenceContainer)seqManager.get(seqIndices[i])).getID();
            int index = overlayManager.indexOf(id);
            if (index == -1) continue;
            result.add(index);
        }
        return result.toArray();
    }

    @Override
    public void dataChanged(DataChangeEvent e) {
        switch (e.getType()) {
            case CLEAR: {
                this.getMarkerContainerManager().clear();
                this.getOverlayContainerManager().clear();
                break;
            }
            case REMOVAL: {
                int i;
                int[] indices = this.toMarkerIndices(e.getIndices());
                for (i = indices.length - 1; i >= 0; --i) {
                    this.getMarkerContainerManager().remove(indices[i]);
                }
                indices = this.toOverlayIndices(e.getIndices());
                for (i = indices.length - 1; i >= 0; --i) {
                    this.getOverlayContainerManager().remove(indices[i]);
                }
                break;
            }
            case VISIBILITY: {
                int i;
                int[] indices = this.toMarkerIndices(e.getIndices());
                for (i = 0; i < indices.length; ++i) {
                    this.getMarkerContainerManager().setVisible(indices[i], ((XYSequenceContainerManager)this.getContainerManager()).isVisible(indices[i]));
                }
                indices = this.toOverlayIndices(e.getIndices());
                for (i = 0; i < indices.length; ++i) {
                    this.getOverlayContainerManager().setVisible(indices[i], ((XYSequenceContainerManager)this.getContainerManager()).isVisible(indices[i]));
                }
                break;
            }
            case BULK_UPDATE: {
                int i = 0;
                while (i < this.getMarkerContainerManager().count()) {
                    if (((XYSequenceContainerManager)this.getContainerManager()).indexOf(((XYSequenceContainer)this.getMarkerContainerManager().get(i)).getID()) == -1) {
                        this.getMarkerContainerManager().remove(i);
                        continue;
                    }
                    ++i;
                }
                i = 0;
                while (i < this.getOverlayContainerManager().count()) {
                    if (((XYSequenceContainerManager)this.getContainerManager()).indexOf(((XYSequenceContainer)this.getOverlayContainerManager().get(i)).getID()) == -1) {
                        this.getOverlayContainerManager().remove(i);
                        continue;
                    }
                    ++i;
                }
                break;
            }
        }
        super.dataChanged(e);
    }
}

