/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.base.BaseRegExp;
import adams.core.option.OptionHandler;
import adams.flow.source.AbstractArrayProvider;
import java.util.Collections;

public class ListVariables
extends AbstractArrayProvider {
    private static final long serialVersionUID = -344345645671109393L;
    protected BaseRegExp m_RegExp;
    protected boolean m_Invert;

    @Override
    public String globalInfo() {
        return "Outputs the names of the currently available variables.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("regexp", "regExp", new BaseRegExp(".*"));
        this.m_OptionManager.add("invert", "invert", false);
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "regExp", this.m_RegExp, this.m_Invert ? "! " : "");
    }

    @Override
    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public String outputArrayTipText() {
        return "Whether to output the variable names in an array rather than one by one.";
    }

    public void setRegExp(BaseRegExp value) {
        this.m_RegExp = value;
        this.reset();
    }

    public BaseRegExp getRegExp() {
        return this.m_RegExp;
    }

    public String regExpTipText() {
        return "The regular expression used for matching the variable names.";
    }

    public void setInvert(boolean value) {
        this.m_Invert = value;
        this.reset();
    }

    public boolean getInvert() {
        return this.m_Invert;
    }

    public String invertTipText() {
        return "If set to true, then the matching sense is inverted.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        this.m_Queue.clear();
        if (this.m_RegExp.isMatchAll()) {
            if (!this.m_Invert) {
                this.m_Queue.addAll(this.getVariables().nameSet());
            }
        } else {
            for (String name : this.getVariables().nameSet()) {
                if (this.m_Invert && !this.m_RegExp.isMatch(name)) {
                    this.m_Queue.add(name);
                    continue;
                }
                if (this.m_Invert || !this.m_RegExp.isMatch(name)) continue;
                this.m_Queue.add(name);
            }
        }
        Collections.sort(this.m_Queue);
        return null;
    }
}

