/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.option.ArrayProducer;
import adams.core.option.OptionHandler;
import adams.flow.core.Token;
import adams.flow.source.AbstractSimpleSource;

public class OptionProducer
extends AbstractSimpleSource {
    private static final long serialVersionUID = -132045002653940359L;
    protected adams.core.option.OptionProducer m_Producer;

    @Override
    public String globalInfo() {
        return "Generates string output from the current flow using the specified option producer.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("producer", "producer", new ArrayProducer());
    }

    @Override
    public String getQuickInfo() {
        return QuickInfoHelper.toString((OptionHandler)this, "producer", this.m_Producer);
    }

    public void setProducer(adams.core.option.OptionProducer value) {
        this.m_Producer = value;
        this.reset();
    }

    public adams.core.option.OptionProducer getProducer() {
        return this.m_Producer;
    }

    public String producerTipText() {
        return "The option producer to use for generating the output.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        try {
            this.m_Producer.produce(this.getRoot());
            this.m_OutputToken = new Token(((Object)this.m_Producer).toString());
            this.m_Producer.cleanUp();
        }
        catch (Exception e) {
            result = this.handleException("Failed to apply option producer!", e);
        }
        return result;
    }
}

