/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.Utils;
import adams.core.option.OptionHandler;
import adams.core.option.OptionTraverserWithResult;
import adams.core.option.VariableLister;
import adams.flow.core.Token;
import adams.flow.core.Unknown;
import adams.flow.source.AbstractSimpleSource;

public class OptionTraverser
extends AbstractSimpleSource {
    private static final long serialVersionUID = -4834816502537753658L;
    protected adams.core.option.OptionTraverser m_Traverser;
    protected TraversalStart m_Start;

    @Override
    public String globalInfo() {
        return "Traverses the options of the flow at run-time.\nUsed for debugging purposes.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("traverser", "traverser", new VariableLister());
        this.m_OptionManager.add("start", "start", (Object)TraversalStart.ROOT);
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "traverser", this.m_Traverser.getClass(), "using: ");
        result = result + QuickInfoHelper.toString((OptionHandler)this, "start", (Object)this.m_Start, ", starting from: ");
        return result;
    }

    public void setTraverser(adams.core.option.OptionTraverser value) {
        this.m_Traverser = value;
        this.reset();
    }

    public adams.core.option.OptionTraverser getTraverser() {
        return this.m_Traverser;
    }

    public String traverserTipText() {
        return "The traverser to use.";
    }

    public void setStart(TraversalStart value) {
        this.m_Start = value;
        this.reset();
    }

    public TraversalStart getStart() {
        return this.m_Start;
    }

    public String startTipText() {
        return "Defines where to start the traversal from.";
    }

    @Override
    public Class[] generates() {
        return new Class[]{Unknown.class};
    }

    @Override
    protected String doExecute() {
        String result = null;
        adams.core.option.OptionTraverser traverser = (adams.core.option.OptionTraverser)Utils.deepCopy(this.m_Traverser);
        this.m_OutputToken = null;
        if (traverser instanceof OptionTraverserWithResult) {
            ((OptionTraverserWithResult)traverser).resetResult();
        }
        switch (this.m_Start) {
            case ROOT: {
                if (this.getRoot() != null) {
                    this.getRoot().getOptionManager().traverse(traverser);
                    break;
                }
                result = "No root available!";
                break;
            }
            case PARENT: {
                if (this.getParent() != null) {
                    this.getParent().getOptionManager().traverse(traverser);
                    break;
                }
                result = "No parent available!";
            }
        }
        if (result == null && traverser instanceof OptionTraverserWithResult) {
            this.m_OutputToken = new Token(((OptionTraverserWithResult)traverser).getResult());
        }
        return result;
    }

    public static enum TraversalStart {
        ROOT,
        PARENT;

    }
}

