/*
 * Decompiled with CFR 0.152.
 */
package adams.flow.source;

import adams.core.QuickInfoHelper;
import adams.core.io.PlaceholderDirectory;
import adams.core.option.OptionHandler;
import adams.flow.core.AutomatableInteractiveActor;
import adams.flow.core.Token;
import adams.flow.source.AbstractInteractiveSource;
import adams.gui.chooser.BaseDirectoryChooser;
import java.io.File;
import java.util.ArrayList;

public class SelectDirectory
extends AbstractInteractiveSource
implements AutomatableInteractiveActor {
    private static final long serialVersionUID = -3223325917850709883L;
    protected String m_DirectoryChooserTitle;
    protected PlaceholderDirectory m_InitialDirectory;
    protected boolean m_AbsoluteDirectoryName;
    protected boolean m_NonInteractive;
    protected Token m_OutputToken;

    @Override
    public String globalInfo() {
        return "Pops up a directory chooser dialog, prompting the user to select a directory. The directory then gets forwarded as string.";
    }

    @Override
    public void defineOptions() {
        super.defineOptions();
        this.m_OptionManager.add("dir-chooser-title", "directoryChooserTitle", "");
        this.m_OptionManager.add("initial-dir", "initialDirectory", new PlaceholderDirectory("."));
        this.m_OptionManager.add("absolute", "absoluteDirectoryName", false);
        this.m_OptionManager.add("non-interactive", "nonInteractive", false);
    }

    @Override
    protected void reset() {
        super.reset();
        this.m_OutputToken = null;
    }

    @Override
    public String getQuickInfo() {
        String result = QuickInfoHelper.toString((OptionHandler)this, "initialDirectory", this.m_InitialDirectory, "directory: ");
        ArrayList<String> options = new ArrayList<String>();
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "absoluteDirectoryName", this.m_AbsoluteDirectoryName, "absolute"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "stopFlowIfCanceled", this.m_StopFlowIfCanceled, "stops flow if canceled"));
        QuickInfoHelper.add(options, QuickInfoHelper.toString((OptionHandler)this, "nonInteractive", this.m_NonInteractive, "non-interactive"));
        result = result + QuickInfoHelper.flatten(options);
        return result;
    }

    public void setDirectoryChooserTitle(String value) {
        this.m_DirectoryChooserTitle = value;
        this.reset();
    }

    public String getDirectoryChooserTitle() {
        return this.m_DirectoryChooserTitle;
    }

    public String directoryChooserTitleTipText() {
        return "The title for the directory chooser dialog.";
    }

    public void setInitialDirectory(PlaceholderDirectory value) {
        this.m_InitialDirectory = value;
        this.reset();
    }

    public PlaceholderDirectory getInitialDirectory() {
        return this.m_InitialDirectory;
    }

    public String initialDirectoryTipText() {
        return "The initial directory for the directory chooser.";
    }

    public void setAbsoluteDirectoryName(boolean value) {
        this.m_AbsoluteDirectoryName = value;
        this.reset();
    }

    public boolean getAbsoluteDirectoryName() {
        return this.m_AbsoluteDirectoryName;
    }

    public String absoluteDirectoryNameTipText() {
        return "If enabled, the directory name is output in absolute instead of relative form.";
    }

    @Override
    public void setNonInteractive(boolean value) {
        this.m_NonInteractive = value;
        this.reset();
    }

    @Override
    public boolean isNonInteractive() {
        return this.m_NonInteractive;
    }

    @Override
    public String nonInteractiveTipText() {
        return "If enabled, the initial directory is forwarded without user interaction.";
    }

    protected Class getItemClass() {
        return String.class;
    }

    @Override
    public boolean doInteract() {
        if (this.m_NonInteractive) {
            this.m_OutputToken = this.m_AbsoluteDirectoryName ? new Token(this.m_InitialDirectory.getAbsolutePath()) : new Token(this.m_InitialDirectory.toString());
            return true;
        }
        boolean result = false;
        BaseDirectoryChooser dirChooser = new BaseDirectoryChooser();
        if (this.m_DirectoryChooserTitle.length() > 0) {
            dirChooser.setDialogTitle(this.m_DirectoryChooserTitle);
        }
        dirChooser.setCurrentDirectory(this.m_InitialDirectory);
        int retVal = dirChooser.showOpenDialog(this.getParentComponent());
        if (retVal == 0) {
            result = true;
            File file = dirChooser.getSelectedFile();
            this.m_OutputToken = this.m_AbsoluteDirectoryName ? new Token(file.getAbsolutePath()) : new Token(file.toString());
        }
        return result;
    }

    @Override
    public Class[] generates() {
        return new Class[]{String.class};
    }

    @Override
    public Token output() {
        Token result = this.m_OutputToken;
        this.m_OutputToken = null;
        return result;
    }

    @Override
    public boolean hasPendingOutput() {
        return this.m_OutputToken != null;
    }
}

